/*
 * Decompiled with CFR 0.152.
 */
package com.starmicronics.utility.POSPrinter.Star;

import com.starmicronics.utility.POSPrinter.BitmapConverter;
import com.starmicronics.utility.POSPrinter.MapModeConversion;
import com.starmicronics.utility.POSPrinter.PrinterFont;
import com.starmicronics.utility.POSPrinter.Star.CommandStar;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import jpos.JposException;
import jpos.config.JposEntry;

public class CommandStarThermal
extends CommandStar {
    private boolean m_capRecFullCut = false;
    private boolean m_capRecPartialCut = false;
    private byte m_multipleHeightCommand = 0;
    private byte m_multipleWidthCommand = 0;
    private MapModeConversion m_mapMode;

    public CommandStarThermal(PrinterFont printerFont, MapModeConversion mapModeConversion, JposEntry jposEntry) {
        super(printerFont, jposEntry);
        this.m_mapMode = mapModeConversion;
        this.m_capRecPartialCut = (Boolean)jposEntry.getPropertyValue("partialCut");
        this.m_capRecFullCut = (Boolean)jposEntry.getPropertyValue("fullCut");
        try {
            if (jposEntry.hasPropertyWithName("PDF417Line") && Integer.class == jposEntry.getPropertyType("PDF417Line")) {
                this.setPdf417Line((Integer)jposEntry.getPropertyValue("PDF417Line"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (jposEntry.hasPropertyWithName("PDF417Column") && Integer.class == jposEntry.getPropertyType("PDF417Column")) {
                this.setPdf417Column((Integer)jposEntry.getPropertyValue("PDF417Column"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (jposEntry.hasPropertyWithName("PDF417Ecc") && Integer.class == jposEntry.getPropertyType("PDF417Ecc")) {
                this.setPdf417Ecc((Integer)jposEntry.getPropertyValue("PDF417Ecc"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (jposEntry.hasPropertyWithName("PDF417ModuleXdim") && Integer.class == jposEntry.getPropertyType("PDF417ModuleXdim")) {
                this.setPdf417ModuleXdim((Integer)jposEntry.getPropertyValue("PDF417ModuleXdim"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (jposEntry.hasPropertyWithName("PDF417Aspect") && Integer.class == jposEntry.getPropertyType("PDF417Aspect")) {
                this.setPdf417Aspect((Integer)jposEntry.getPropertyValue("PDF417Aspect"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (jposEntry.hasPropertyWithName("QRCodeModel") && Integer.class == jposEntry.getPropertyType("QRCodeModel")) {
                this.setQrCodeModel((Integer)jposEntry.getPropertyValue("QRCodeModel"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (jposEntry.hasPropertyWithName("QRCodeEcc") && Integer.class == jposEntry.getPropertyType("QRCodeEcc")) {
                this.setQrCodeEcc((Integer)jposEntry.getPropertyValue("QRCodeEcc"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (jposEntry.hasPropertyWithName("QRCodeCellSize") && Integer.class == jposEntry.getPropertyType("QRCodeCellSize")) {
                this.setQrCodeCellSize((Integer)jposEntry.getPropertyValue("QRCodeCellSize"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List initializeCommand() {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        arrayList.add(new byte[]{27, 29, 116, this.m_printerFont.getCharacterSetByteCommand()});
        if (this.m_printerFont.getCapFontB()) {
            arrayList.add(new byte[]{27, 30, 70, this.m_printerFont.getFontSelect()});
        }
        arrayList.add(new byte[]{27, 32, this.m_printerFont.getRightSideCharacterSpacing()});
        if (24 == this.m_printerFont.getDotLineSpacing()) {
            arrayList.add(new byte[]{27, 122, 48});
        } else {
            arrayList.add(new byte[]{27, 122, 49});
        }
        arrayList.add(new byte[]{27, 70});
        arrayList.add(new byte[]{27, 45, 48});
        arrayList.add(new byte[]{27, 53});
        arrayList.add(new byte[]{27, 87, 48});
        arrayList.add(new byte[]{27, 104, 48});
        arrayList.add(new byte[]{27, 29, 97, 48});
        return arrayList;
    }

    public List barCodeCommand(String string, int n, int n2, int n3, int n4, int n5) throws JposException {
        int n6;
        int n7;
        int n8;
        byte by;
        int n9;
        int n10;
        byte[] byArray;
        int n11;
        int n12 = 0;
        int n13 = 0;
        byte[] byArray2 = null;
        byte[] byArray3 = string.getBytes();
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        switch (n) {
            case 201: 
            case 204: {
                n5 = -11;
                n2 = 1;
            }
        }
        if (-11 == n5) {
            n11 = 49;
        } else if (-13 == n5) {
            n11 = 50;
        } else {
            throw new JposException(106, "This request failed because the specified text placement is not supported.");
        }
        if (1 > n2 || 255 < n2) {
            throw new JposException(106, "This request failed because the specified height is not supported.");
        }
        if (n3 < 1 || n3 > this.m_printerFont.getLineWidthDot()) {
            throw new JposException(106, "This request failed because the specified width is not supported.");
        }
        if (0 > this.m_printerFont.getLineWidthDot() - n4 - n3) {
            throw new JposException(106, "This request failed because the specified alignment is not supported.");
        }
        if (123 == n || 110 == n) {
            if (byArray3.length < 1 || byArray3.length > 255) {
                throw new JposException(106);
            }
            byArray = null;
            n10 = 0;
            n12 = 54;
            n13 = 49;
            for (n9 = 0; n9 < 2; ++n9) {
                by = 0;
                for (n8 = 0; n8 < byArray3.length; ++n8) {
                    byte by2 = byArray3[n8];
                    if (by == 0) {
                        if (by2 == 123) {
                            by = 1;
                            continue;
                        }
                        if (by2 < 0 || by2 > 127) {
                            throw new JposException(106);
                        }
                        if (by2 >= 0 && by2 <= 31) {
                            if (null != byArray) {
                                byArray[n10] = 37;
                            }
                            ++n10;
                            if (null != byArray) {
                                byArray[n10] = (byte)(64 + by2);
                            }
                            ++n10;
                            continue;
                        }
                        if (by2 == 37) {
                            if (null != byArray) {
                                byArray[n10] = 37;
                            }
                            ++n10;
                            if (null != byArray) {
                                byArray[n10] = 48;
                            }
                            ++n10;
                            continue;
                        }
                        if (by2 == 127) {
                            if (null != byArray) {
                                byArray[n10] = 37;
                            }
                            ++n10;
                            if (null != byArray) {
                                byArray[n10] = 53;
                            }
                            ++n10;
                            continue;
                        }
                        if (null != byArray) {
                            byArray[n10] = by2;
                        }
                        ++n10;
                        continue;
                    }
                    switch (by2) {
                        case 83: {
                            break;
                        }
                        case 65: {
                            if (null != byArray) {
                                byArray[n10] = 37;
                            }
                            ++n10;
                            if (null != byArray) {
                                byArray[n10] = 54;
                            }
                            ++n10;
                            break;
                        }
                        case 66: {
                            if (null != byArray) {
                                byArray[n10] = 37;
                            }
                            ++n10;
                            if (null != byArray) {
                                byArray[n10] = 55;
                            }
                            ++n10;
                            break;
                        }
                        case 67: {
                            if (null != byArray) {
                                byArray[n10] = 37;
                            }
                            ++n10;
                            if (null != byArray) {
                                byArray[n10] = 56;
                            }
                            ++n10;
                            break;
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: {
                            if (null != byArray) {
                                byArray[n10] = 37;
                            }
                            ++n10;
                            if (null != byArray) {
                                byArray[n10] = by2;
                            }
                            ++n10;
                            break;
                        }
                        case 123: {
                            if (null != byArray) {
                                byArray[n10] = 123;
                            }
                            ++n10;
                            break;
                        }
                        default: {
                            throw new JposException(106);
                        }
                    }
                    by = 0;
                }
                if (null != byArray) continue;
                byArray = new byte[n10];
                n10 = 0;
            }
            byArray3 = byArray;
        } else if (101 == n) {
            if (byArray3.length != 11 && byArray3.length != 12) {
                throw new JposException(106, "This request failed because UPC-A barcodes require 11 or 12 data digits to be specified.");
            }
            n12 = 49;
            for (n8 = 0; n8 < byArray3.length; ++n8) {
                if (byArray3[n8] >= 48 && byArray3[n8] <= 57) continue;
                throw new JposException(106, "This request failed because UPC-A barcodes require all data digits to be between '0' and '9'.");
            }
            if (n3 < 285) {
                n3 = 190;
                n13 = 49;
            } else if (n3 < 380) {
                n3 = 285;
                n13 = 50;
            } else {
                n3 = 380;
                n13 = 51;
            }
        } else if (102 == n) {
            if (byArray3.length != 11 && byArray3.length != 12) {
                throw new JposException(106, "This request failed because UPC-E barcodes require 11 or 12 data digits to be specified.");
            }
            n12 = 48;
            for (n8 = 0; n8 < byArray3.length; ++n8) {
                if (byArray3[n8] >= 48 && byArray3[n8] <= 57) continue;
                throw new JposException(106, "This request failed because UPC-E barcodes require all data digits to be between '0' and '9'.");
            }
            if (n3 < 153) {
                n3 = 102;
                n13 = 49;
            } else if (n3 < 204) {
                n3 = 153;
                n13 = 50;
            } else {
                n3 = 204;
                n13 = 51;
            }
        } else if (103 == n) {
            if (byArray3.length != 7 && byArray3.length != 8) {
                throw new JposException(106, "This request failed because JAN8 barcodes require 7 or 8 data digits to be specified.");
            }
            n12 = 50;
            for (n8 = 0; n8 < byArray3.length; ++n8) {
                if (byArray3[n8] >= 48 && byArray3[n8] <= 57) continue;
                throw new JposException(106, "This request failed because JAN8 barcodes require all data digits to be between '0' and '9'.");
            }
            if (n3 < 201) {
                n3 = 134;
                n13 = 49;
            } else if (n3 < 268) {
                n3 = 201;
                n13 = 50;
            } else {
                n3 = 268;
                n13 = 51;
            }
        } else if (104 == n) {
            if (byArray3.length != 12 && byArray3.length != 13) {
                throw new JposException(106, "This request failed because JAN13 barcodes require 12 or 13 data digits to be specified.");
            }
            n12 = 51;
            for (n8 = 0; n8 < byArray3.length; ++n8) {
                if (byArray3[n8] >= 48 && byArray3[n8] <= 57) continue;
                throw new JposException(106, "This request failed because JAN13 barcodes require all data digits to be between '0' and '9'.");
            }
            if (n3 < 285) {
                n3 = 190;
                n13 = 49;
            } else if (n3 < 380) {
                n3 = 285;
                n13 = 50;
            } else {
                n3 = 380;
                n13 = 51;
            }
        } else if (106 == n) {
            if (byArray3.length < 1 || byArray3.length > 255) {
                throw new JposException(106, "This request failed because ITF barcodes require between 1 and 255 data digits to be specified.");
            }
            n12 = 53;
            n7 = 4;
            n6 = 0;
            for (n8 = 0; n8 < byArray3.length; ++n8) {
                if (byArray3[n8] < 48 || byArray3[n8] > 57) {
                    throw new JposException(106, "This request failed because ITF barcodes require all data digits to be between '0' and '9'.");
                }
                n7 += 3;
                n6 += 2;
            }
            if (byArray3.length % 2 != 0) {
                n7 += 3;
                n6 += 2;
            }
            if (n3 < (n7 += 2) * 2 + ++n6 * 5) {
                n3 = n7 * 2 + n6 * 4;
                n13 = 52;
            } else if (n3 < n7 * 2 + n6 * 6) {
                n3 = n7 * 2 + n6 * 5;
                n13 = 49;
            } else if (n3 < n7 * 3 + n6 * 9) {
                n3 = n7 * 2 + n6 * 6;
                n13 = 55;
            } else if (n3 < n7 * 4 + n6 * 8) {
                n3 = n7 * 3 + n6 * 9;
                n13 = 56;
            } else if (n3 < n7 * 4 + n6 * 10) {
                n3 = n7 * 4 + n6 * 8;
                n13 = 53;
            } else if (n3 < n7 * 4 + n6 * 12) {
                n3 = n7 * 4 + n6 * 10;
                n13 = 50;
            } else if (n3 < n7 * 6 + n6 * 12) {
                n3 = n7 * 4 + n6 * 12;
                n13 = 57;
            } else if (n3 < n7 * 6 + n6 * 15) {
                n3 = n7 * 6 + n6 * 12;
                n13 = 54;
            } else {
                n3 = n7 * 6 + n6 * 15;
                n13 = 51;
            }
        } else if (107 == n) {
            if (byArray3.length < 1 || byArray3.length > 255) {
                throw new JposException(106, "This request failed because CodeBar-A barcodes require between 1 and 255 data digits to be specified.");
            }
            n12 = 56;
            n7 = 0;
            n6 = 0;
            block39: for (n8 = 0; n8 < byArray3.length; ++n8) {
                if (byArray3[n8] >= 48 && byArray3[n8] <= 57) {
                    n7 += 6;
                    n6 += 2;
                    continue;
                }
                if (byArray3[n8] >= 65 && byArray3[n8] <= 68) {
                    n7 += 5;
                    n6 += 3;
                    continue;
                }
                if (byArray3[n8] >= 97 && byArray3[n8] <= 100) {
                    n7 += 5;
                    n6 += 3;
                    continue;
                }
                switch (byArray3[n8]) {
                    case 36: {
                        n7 += 6;
                        n6 += 2;
                        continue block39;
                    }
                    case 43: {
                        n7 += 5;
                        n6 += 3;
                        continue block39;
                    }
                    case 45: {
                        n7 += 6;
                        n6 += 2;
                        continue block39;
                    }
                    case 46: {
                        n7 += 5;
                        n6 += 3;
                        continue block39;
                    }
                    case 47: {
                        n7 += 5;
                        n6 += 3;
                        continue block39;
                    }
                    case 58: {
                        n7 += 5;
                        n6 += 3;
                        continue block39;
                    }
                    default: {
                        throw new JposException(106, "This request failed because CodeBar-A barcodes do not support 1 or more of the specified data digits.");
                    }
                }
            }
            if (n3 < --n7 * 2 + n6 * 5) {
                n3 = n7 * 2 + n6 * 4;
                n13 = 55;
            } else if (n3 < n7 * 2 + n6 * 6) {
                n3 = n7 * 2 + n6 * 5;
                n13 = 52;
            } else if (n3 < n7 * 3 + n6 * 6) {
                n3 = n7 * 2 + n6 * 6;
                n13 = 49;
            } else if (n3 < n7 * 3 + n6 * 8) {
                n3 = n7 * 3 + n6 * 6;
                n13 = 56;
            } else if (n3 < n7 * 3 + n6 * 9) {
                n3 = n7 * 3 + n6 * 8;
                n13 = 53;
            } else if (n3 < n7 * 4 + n6 * 8) {
                n3 = n7 * 3 + n6 * 9;
                n13 = 50;
            } else if (n3 < n7 * 4 + n6 * 10) {
                n3 = n7 * 4 + n6 * 8;
                n13 = 57;
            } else if (n3 < n7 * 4 + n6 * 12) {
                n3 = n7 * 4 + n6 * 10;
                n13 = 54;
            } else {
                n3 = n7 * 4 + n6 * 12;
                n13 = 51;
            }
        } else if (108 == n) {
            if (byArray3.length < 1 || byArray3.length > 255) {
                throw new JposException(106, "This request failed because Code39 barcodes require between 1 and 255 data digits to be specified.");
            }
            n12 = 52;
            n7 = 7;
            n6 = 3;
            for (n8 = 0; n8 < byArray3.length; ++n8) {
                if (!(byArray3[n8] >= 48 && byArray3[n8] <= 57 || byArray3[n8] >= 65 && byArray3[n8] <= 90)) {
                    switch (byArray3[n8]) {
                        case 32: {
                            break;
                        }
                        case 36: {
                            break;
                        }
                        case 37: {
                            break;
                        }
                        case 43: {
                            break;
                        }
                        case 45: {
                            break;
                        }
                        case 46: {
                            break;
                        }
                        case 47: {
                            break;
                        }
                        default: {
                            throw new JposException(106, "This request failed because Code39 barcodes do not support 1 or more of the specified data digits.");
                        }
                    }
                }
                n7 += 7;
                n6 += 3;
            }
            if (n3 < (n7 += 6) * 2 + (n6 += 3) * 5) {
                n3 = n7 * 2 + n6 * 4;
                n13 = 55;
            } else if (n3 < n7 * 2 + n6 * 6) {
                n3 = n7 * 2 + n6 * 5;
                n13 = 52;
            } else if (n3 < n7 * 3 + n6 * 6) {
                n3 = n7 * 2 + n6 * 6;
                n13 = 49;
            } else if (n3 < n7 * 3 + n6 * 8) {
                n3 = n7 * 3 + n6 * 6;
                n13 = 56;
            } else if (n3 < n7 * 3 + n6 * 9) {
                n3 = n7 * 3 + n6 * 8;
                n13 = 53;
            } else if (n3 < n7 * 4 + n6 * 8) {
                n3 = n7 * 3 + n6 * 9;
                n13 = 50;
            } else if (n3 < n7 * 4 + n6 * 10) {
                n3 = n7 * 4 + n6 * 8;
                n13 = 57;
            } else if (n3 < n7 * 4 + n6 * 12) {
                n3 = n7 * 4 + n6 * 10;
                n13 = 54;
            } else {
                n3 = n7 * 4 + n6 * 12;
                n13 = 51;
            }
        } else if (109 == n) {
            if (byArray3.length < 1 || byArray3.length > 255) {
                throw new JposException(106, "This request failed because Code93 barcodes require between 1 and 255 data digits to be specified.");
            }
            n12 = 55;
            byArray = null;
            n10 = 0;
            n7 = 9;
            for (n9 = 0; n9 < 2; ++n9) {
                for (n8 = 0; n8 < byArray3.length; ++n8) {
                    by = byArray3[n8];
                    if (by < 0 || by > 127) {
                        throw new JposException(106);
                    }
                    if (n9 == 0) {
                        n7 += 9;
                    }
                    if (!(by == 32 || by >= 36 && by <= 37 || by == 43 || by >= 45 && by <= 47 || by >= 48 && by <= 57 || by >= 65 && by <= 90 || n9 != 0)) {
                        n7 += 9;
                    }
                    if (by >= 0 && by <= 31) {
                        if (null != byArray) {
                            byArray[n10] = 37;
                        }
                        ++n10;
                        if (null != byArray) {
                            byArray[n10] = 64;
                        }
                        ++n10;
                        if (null != byArray) {
                            byArray[n10] = by;
                        }
                        ++n10;
                        continue;
                    }
                    if (by == 37) {
                        if (null != byArray) {
                            byArray[n10] = 37;
                        }
                        ++n10;
                        if (null != byArray) {
                            byArray[n10] = 48;
                        }
                        ++n10;
                        continue;
                    }
                    if (by == 127) {
                        if (null != byArray) {
                            byArray[n10] = 37;
                        }
                        ++n10;
                        if (null != byArray) {
                            byArray[n10] = 53;
                        }
                        ++n10;
                        continue;
                    }
                    if (null != byArray) {
                        byArray[n10] = by;
                    }
                    ++n10;
                }
                if (null != byArray) continue;
                byArray = new byte[n10];
                n10 = 0;
            }
            n7 += 9;
            n7 += 9;
            byArray3 = byArray;
            if (n3 < (n7 += 10) * 3) {
                n3 = n7 * 2;
                n13 = 49;
            } else if (n3 < n7 * 4) {
                n3 = n7 * 3;
                n13 = 50;
            } else {
                n3 = n7 * 4;
                n13 = 51;
            }
        } else if (204 != n && 201 != n) {
            throw new JposException(106, "This request failed because the specified symbology is not supported.");
        }
        if (1 == this.getRotateSpecial()) {
            arrayList.add(new byte[]{18});
        } else {
            arrayList.add(new byte[]{15});
        }
        this.addArrayListElementsLast(this.initializeCommand(), arrayList);
        if (0 <= n4) {
            arrayList.add(new byte[]{27, 29, 65, (byte)(n4 % 256), (byte)(n4 / 256)});
        } else if (n4 == -1) {
            arrayList.add(new byte[]{27, 29, 97, 0});
        } else if (n4 == -2) {
            arrayList.add(new byte[]{27, 29, 97, 1});
        } else if (n4 == -3) {
            arrayList.add(new byte[]{27, 29, 97, 2});
        }
        switch (n) {
            case 201: {
                byArray2 = new byte[]{27, 29, 120, 83, 48, 1, (byte)this.getPpdf417Line(), (byte)this.getPpdf417Column()};
                arrayList.add(byArray2);
                byArray2 = new byte[]{27, 29, 120, 83, 49, (byte)this.getPpdf417Ecc()};
                arrayList.add(byArray2);
                byArray2 = new byte[]{27, 29, 120, 83, 50, (byte)this.getPpdf417ModuleXdim()};
                arrayList.add(byArray2);
                byArray2 = new byte[]{27, 29, 120, 83, 51, (byte)this.getPpdf417Aspect()};
                arrayList.add(byArray2);
                byArray2 = new byte[6 + byArray3.length + 1];
                int n14 = byArray3.length % 256;
                n10 = byArray3.length / 256;
                byArray2[0] = 27;
                byArray2[1] = 29;
                byArray2[2] = 120;
                byArray2[3] = 68;
                byArray2[4] = (byte)n14;
                byArray2[5] = (byte)n10;
                for (n8 = 0; n8 < byArray3.length; ++n8) {
                    byArray2[6 + n8] = byArray3[n8];
                }
                arrayList.add(byArray2);
                byArray2 = new byte[]{27, 29, 120, 80};
                break;
            }
            case 204: {
                byArray2 = new byte[]{27, 29, 121, 83, 48, (byte)this.getQrCodeModel()};
                arrayList.add(byArray2);
                byArray2 = new byte[]{27, 29, 121, 83, 49, (byte)this.getQrCodeEcc()};
                arrayList.add(byArray2);
                byArray2 = new byte[]{27, 29, 121, 83, 50, (byte)this.getQrCodeCellSize()};
                arrayList.add(byArray2);
                byArray2 = new byte[8 + byArray3.length + 1];
                int n15 = byArray3.length % 256;
                n10 = byArray3.length / 256;
                byArray2[0] = 27;
                byArray2[1] = 29;
                byArray2[2] = 121;
                byArray2[3] = 68;
                byArray2[4] = 49;
                byArray2[5] = 0;
                byArray2[6] = (byte)n15;
                byArray2[7] = (byte)n10;
                for (n8 = 0; n8 < byArray3.length; ++n8) {
                    byArray2[8 + n8] = byArray3[n8];
                }
                arrayList.add(byArray2);
                byArray2 = new byte[]{27, 29, 121, 80};
                break;
            }
            default: {
                byArray2 = new byte[6 + byArray3.length + 1];
                byArray2[0] = 27;
                byArray2[1] = 98;
                byArray2[2] = n12;
                byArray2[3] = n11;
                byArray2[4] = n13;
                byArray2[5] = (byte)n2;
                for (n8 = 0; n8 < byArray3.length; ++n8) {
                    byArray2[6 + n8] = byArray3[n8];
                }
                byArray2[6 + n8] = 30;
            }
        }
        arrayList.add(byArray2);
        arrayList.add(new byte[]{27, 29, 97, 0});
        arrayList.add(new byte[]{27, 29, 65, 0, 0});
        return arrayList;
    }

    public byte[] paperCutCommand(int n, boolean bl, boolean bl2) throws JposException {
        byte[] byArray = new byte[]{27, 100, 0};
        if (100 < n) {
            byArray[2] = bl ? (!this.m_capRecPartialCut && !this.m_capRecFullCut ? 116 : 2) : 0;
        } else {
            if (0 > n) {
                throw new JposException(106, "This request is illegal");
            }
            if (100 == n) {
                byArray[2] = bl ? (!this.m_capRecPartialCut && !this.m_capRecFullCut ? 116 : 2) : 0;
            } else if (0 == n) {
                if (bl) {
                    if (!this.m_capRecPartialCut && !this.m_capRecFullCut) {
                        byArray[2] = 116;
                    } else {
                        byArray[1] = 97;
                        byArray[2] = 1 > this.m_printerFont.getRecLinesToPaperCut() ? 1 : (127 < this.m_printerFont.getRecLinesToPaperCut() ? 127 : (byte)this.m_printerFont.getRecLinesToPaperCut());
                    }
                }
            } else {
                byArray[2] = bl ? (!this.m_capRecPartialCut && !this.m_capRecFullCut ? 116 : 3) : 1;
            }
        }
        return byArray;
    }

    protected void multipleHeightSetting(int n, boolean bl) throws JposException {
        if (1 > n) {
            if (bl) {
                throw new JposException(106, "This request is illegal and print with the normal height.");
            }
            this.m_multipleHeightCommand = 0;
        } else if (6 < n) {
            if (bl) {
                throw new JposException(106, "This request is illegal and print with the height scaled 6 times the normal size.");
            }
            this.m_multipleHeightCommand = (byte)5;
        } else {
            this.m_multipleHeightCommand = (byte)(n - 1);
        }
    }

    protected void multipleWidthSetting(int n, boolean bl) throws JposException {
        if (1 > n) {
            if (bl) {
                throw new JposException(106, "This request is illegal and set character size to normal.");
            }
            this.m_multipleWidthCommand = 0;
        } else if (6 < n) {
            if (bl) {
                throw new JposException(106, "This request is illegal and set character size to 6 width.");
            }
            this.m_multipleWidthCommand = (byte)5;
        } else {
            this.m_multipleWidthCommand = (byte)(n - 1);
        }
    }

    protected byte[] multipleHeightAndWidthCommand() throws JposException {
        return new byte[]{27, 87, this.m_multipleWidthCommand, 27, 104, this.m_multipleHeightCommand};
    }

    protected byte[] feedUnitsCommand(int n, boolean bl) throws JposException {
        int n2 = this.m_mapMode.mapModeToDotHeight(n);
        n2 = 0 != n2 % 2 ? n2 / 2 + 1 : (n2 /= 2);
        if (1 > n2) {
            if (bl) {
                throw new JposException(106, "This request is illegal and feed 1 dot.");
            }
            n2 = 1;
        } else if (255 < n2) {
            if (bl) {
                throw new JposException(106, "This request is illegal and feed 255 dots.");
            }
            n2 = 255;
        }
        return new byte[]{27, 74, (byte)n2};
    }

    protected byte[] feedReverseCommand(int n, boolean bl) throws JposException {
        if (bl) {
            throw new JposException(106, "This request failed because this request is not supported this print station.");
        }
        return null;
    }

    public List bitmapCommand(Image image, int n, int n2, int n3, int n4) throws JposException {
        int n5 = 0;
        Object var7_7 = null;
        List list = null;
        list = this.initializeCommand();
        this.addArrayListElementsFirst(this.headerCommand(), list);
        try {
            if (n != -11) {
                image = new ImageIcon(image.getScaledInstance(n, -1, 1)).getImage();
            }
            n = image.getWidth(null);
            n5 = image.getHeight(null);
        }
        catch (Exception exception) {
            throw new JposException(114, 207);
        }
        if (n <= 0) {
            throw new JposException(106, "This request failed because the bitmap width is 0.");
        }
        if (n > this.m_printerFont.getLineWidthDot()) {
            throw new JposException(114, 206);
        }
        if (0 > this.m_printerFont.getLineWidthDot() - n2 - n) {
            throw new JposException(106, "This request failed because the aligment parameter is not valid.");
        }
        if (n2 == -1) {
            n2 = 0;
        } else if (n2 == -2) {
            n2 = (this.m_printerFont.getLineWidthDot() - n) / 2;
        } else if (n2 == -3) {
            n2 = this.m_printerFont.getLineWidthDot() - n;
        }
        if (n5 <= 0) {
            throw new JposException(106, "This request failed because the bitmap height is 0.");
        }
        try {
            BitmapConverter bitmapConverter = new BitmapConverter(image, n3, n4);
            if (n > 1024) {
                n = 1024;
            }
            boolean bl = false;
            int n6 = 0;
            for (int i = 0; i < n5; ++i) {
                int n7;
                byte[] byArray = new byte[4 + n * 3];
                byArray[0] = 27;
                byArray[1] = 88;
                byArray[2] = (byte)(n % 256);
                byArray[3] = (byte)(n / 256);
                int n8 = 4;
                int n9 = -1;
                int n10 = 24;
                if (n5 - i < 24) {
                    n10 = n5 - i;
                }
                for (n7 = n - 1; n7 >= 0; --n7) {
                    if (!bitmapConverter.isPixelBlack(n7, i)) continue;
                    n9 = n7;
                    break;
                }
                if (n9 == -1) {
                    ++n6;
                    continue;
                }
                for (n7 = 0; n7 < n; ++n7) {
                    int n11 = (n10 + 7) / 8;
                    for (int j = 0; j < n11; ++j) {
                        int n12 = 0;
                        int n13 = 8;
                        if (j == n11 - 1) {
                            n13 = n10 / 8 == 0 ? 8 : n10 - (n11 - 1) * 8;
                        }
                        for (int k = 0; k < n13; ++k) {
                            n12 = (byte)(n12 << 1);
                            if (!bitmapConverter.isPixelBlack(n7, i + j * 8 + k)) continue;
                            n12 = (byte)(n12 | 1);
                        }
                        if ((n12 = (int)((byte)(n12 << 8 - n13))) != 0 && n9 < n7) {
                            n9 = n7;
                        }
                        byArray[n8++] = n12;
                    }
                    n8 += 3 - n11;
                }
                n7 = 1;
                if (n7 != 0 && ++n9 < n) {
                    byArray[2] = (byte)(n9 % 256);
                    byArray[3] = (byte)(n9 / 256);
                    System.arraycopy(byArray, 4, byArray, 4, n9 * 3);
                    n8 = 4 + n9 * 3;
                }
                while (n6 != 0) {
                    byte[] byArray2 = new byte[]{27, 73, -1};
                    if (n6 > 255) {
                        n6 -= 255;
                    } else {
                        byArray2[2] = (byte)n6;
                        n6 = 0;
                    }
                    list.add(byArray2);
                }
                if (n2 != 0) {
                    byte[] byArray3 = new byte[]{27, 29, 65, (byte)(n2 % 256), (byte)(n2 / 256)};
                    list.add(byArray3);
                }
                byte[] byArray4 = new byte[n8];
                System.arraycopy(byArray, 0, byArray4, 0, n8);
                list.add(byArray4);
                byte[] byArray5 = new byte[]{27, 73, (byte)n10};
                list.add(byArray5);
                i += n10 - 1;
            }
            while (n6 != 0) {
                byte[] byArray = new byte[]{27, 73, -1};
                if (n6 > 255) {
                    n6 -= 255;
                } else {
                    byArray[2] = (byte)n6;
                    n6 = 0;
                }
                list.add(byArray);
            }
        }
        catch (Exception exception) {
            throw new JposException(114, 207);
        }
        return list;
    }
}

