/*
 * Decompiled with CFR 0.152.
 */
package com.starmicronics.utility.POSPrinter.Star;

import com.starmicronics.utility.POSPrinter.CommandCreator;
import com.starmicronics.utility.POSPrinter.PrinterFont;
import java.awt.Image;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import jpos.JposException;
import jpos.config.JposEntry;

public abstract class CommandStar
extends CommandCreator {
    private int m_DBCS = 0;
    protected PrinterFont m_printerFont = null;
    private static final int SJIS = 1;
    private static final int EUC_KR = 2;
    private static final int GB2312 = 3;
    private static final int GB18030 = 4;
    private static final int BIG5 = 5;
    private boolean m_capNvBitImage = false;

    public CommandStar(PrinterFont printerFont, JposEntry jposEntry) {
        this.m_printerFont = printerFont;
        if (jposEntry.hasPropertyWithName("useNVBitImage") && Boolean.class == jposEntry.getPropertyType("useNVBitImage")) {
            this.m_capNvBitImage = (Boolean)jposEntry.getPropertyValue("useNVBitImage");
        }
        if (((String)jposEntry.getPropertyValue("DBCS")).equals("SJIS")) {
            this.m_DBCS = 1;
        } else if (((String)jposEntry.getPropertyValue("DBCS")).equals("EUC_KR")) {
            this.m_DBCS = 2;
        } else if (((String)jposEntry.getPropertyValue("DBCS")).equals("GB2312")) {
            this.m_DBCS = 3;
        } else if (((String)jposEntry.getPropertyValue("DBCS")).equals("GB18030")) {
            this.m_DBCS = 4;
        } else if (((String)jposEntry.getPropertyValue("DBCS")).equals("Big5")) {
            this.m_DBCS = 5;
        }
    }

    public List headerCommand() {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        byte[] byArray = new byte[1];
        if (1 == this.getRotatePrint()) {
            byArray[0] = 18;
        } else if (259 == this.getRotatePrint()) {
            byArray[0] = 15;
        }
        arrayList.add(byArray);
        try {
            this.multipleHeightSetting(1, false);
            this.multipleWidthSetting(1, false);
        }
        catch (JposException jposException) {
            // empty catch block
        }
        return arrayList;
    }

    protected byte[] boldCommand() {
        return new byte[]{27, 69};
    }

    protected byte[] boldCommandReversed() {
        return new byte[]{27, 70};
    }

    protected byte[] justifyLeftCommand() {
        return new byte[]{27, 29, 97, 48};
    }

    protected byte[] justifyCenterCommand() {
        return new byte[]{27, 29, 97, 49};
    }

    protected byte[] justifyRightCommand() {
        return new byte[]{27, 29, 97, 50};
    }

    protected byte[] underlineCommand(int n, boolean bl) throws JposException {
        byte[] byArray = new byte[]{27, 45, 49};
        if (-1 != n && 2 != n) {
            if (0 == n) {
                byArray[2] = 0;
            } else if (bl) {
                throw new JposException(106, "This request is illegal and modify 2-dot thick underline.");
            }
        }
        return byArray;
    }

    protected byte[] feedLinesCommand(int n, boolean bl) throws JposException {
        byte[] byArray = new byte[]{27, 97, 1};
        if (0 == n) {
            if (bl) {
                throw new JposException(106, "This request is illegal and feed 1 line.");
            }
        } else if (127 < n) {
            if (bl) {
                throw new JposException(106, "This request is illegal and feed 127 lines.");
            }
            byArray[2] = 127;
        } else {
            byArray[2] = (byte)n;
        }
        return byArray;
    }

    protected byte[] alternateColorCommand(int n, boolean bl) throws JposException {
        if (bl) {
            throw new JposException(111, "This request is failure because the submitted data is not supported.");
        }
        return new byte[0];
    }

    protected byte[] reverseVideoCommand(boolean bl) throws JposException {
        return new byte[]{27, 52};
    }

    protected byte[] reverseVideoCommandReversed(boolean bl) throws JposException {
        return new byte[]{27, 53};
    }

    public abstract List bitmapCommand(Image var1, int var2, int var3, int var4, int var5) throws JposException;

    protected boolean convertColor2Mono(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        return n2 * 30 + n3 * 59 + n4 * 11 < 12800;
    }

    public byte[] selectReceiptStationCommand() {
        return new byte[]{27, 43, 65, 48};
    }

    public byte[] selectSlipStationCommand() {
        return new byte[]{27, 43, 65, 51};
    }

    protected byte[] getCharacterCodeBytes(String string) {
        try {
            if (0 == this.m_DBCS) {
                switch (this.m_printerFont.getCharacterSet()) {
                    case 928: {
                        return string.getBytes("ISO8859_7");
                    }
                    case 932: {
                        return string.getBytes("SJIS");
                    }
                    case 998: {
                        return string.getBytes("iso-8859-1");
                    }
                    case 999: {
                        return string.getBytes("Cp1252");
                    }
                    case 437: 
                    case 737: 
                    case 852: 
                    case 855: 
                    case 857: 
                    case 858: 
                    case 860: 
                    case 861: 
                    case 862: 
                    case 863: 
                    case 864: 
                    case 865: 
                    case 866: 
                    case 869: 
                    case 874: 
                    case 1250: 
                    case 1251: 
                    case 1252: {
                        return string.getBytes("Cp" + Integer.toString(this.m_printerFont.getCharacterSet()));
                    }
                }
                return string.getBytes("iso-8859-1");
            }
            switch (this.m_DBCS) {
                case 1: {
                    return string.getBytes("MS932");
                }
                case 2: {
                    return string.getBytes("EUC_KR");
                }
                case 3: {
                    return string.getBytes("EUC_CN");
                }
                case 4: {
                    return string.getBytes("GB18030");
                }
                case 5: {
                    return string.getBytes("Big5");
                }
            }
            return string.getBytes("iso-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    protected boolean getCapNvBitImage() {
        return this.m_capNvBitImage;
    }
}

