/*
 * Decompiled with CFR 0.152.
 */
package com.starmicronics.starjavapos.Star;

import com.starmicronics.commandemulator.CommandEmulator;
import com.starmicronics.stario.StarIOPort;
import com.starmicronics.stario.StarIOPortException;
import com.starmicronics.stario.StarPrinterStatus;
import com.starmicronics.utility.AsyncOutputDataStruct;
import com.starmicronics.utility.POSPrinter.PrinterFont;
import com.starmicronics.utility.POSPrinter.Star.CommandStar;
import com.starmicronics.utility.POSPrinter.Star.CommandStarSlip;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.ErrorEvent;
import jpos.events.JposEvent;
import jpos.events.OutputCompleteEvent;
import jpos.events.StatusUpdateEvent;
import jpos.loader.JposServiceInstance;
import jpos.services.BaseService;
import jpos.services.EventCallbacks;

public class POSPrinterStarBase
implements BaseService,
JposServiceInstance,
ActionListener {
    private boolean[] m_claimLock = new boolean[1];
    private boolean m_deviceEnabled;
    private boolean m_freezeEvents;
    protected int[] m_serviceState = new int[]{1};
    private int[] m_powerState = new int[]{2000};
    private int[] m_powerNotifyEnabled = new int[]{0};
    protected boolean m_flagWhenIdle;
    protected int m_outputId = 0;
    protected int m_errorLevel = 1;
    protected int m_errorStation = 2;
    protected String m_errorString = "";
    protected String m_checkHealthText = "";
    protected boolean m_clearOutputPending = false;
    private boolean m_eventThreadLife = true;
    private boolean m_outputThreadLife = true;
    private boolean m_statusThreadLife = true;
    protected boolean m_processingAsyncOutput = false;
    protected Vector m_eventQueue = new Vector();
    protected List m_asyncOutputQueue = new ArrayList();
    protected Object m_asyncOutputLock = new Object();
    protected Object m_eventLock = new Object();
    private Object m_statusLock = new Object();
    private Thread m_eventThread;
    private Thread m_outputThread;
    private Thread m_statusThread;
    protected StarPrinterStatus[] m_cachedStatus = new StarPrinterStatus[]{new StarPrinterStatus()};
    private String m_commandEmulatorConfig;
    private CommandEmulator m_commandEmulator;
    private StarIOPort m_port;
    private String m_portName;
    private String m_portSettings;
    private int m_ioTimeoutMillis = 5000;
    private int m_ioProgressTimeout = 10000;
    private int m_etbTimeoutMillis = 10000;
    private boolean m_doCheckedBlockPrinting = true;
    private boolean m_autoReset = false;
    private EventCallbacks m_eventCallbacks;
    protected JRadioButton radio1;
    protected JRadioButton radio2;
    protected JRadioButton radio3;
    protected JButton button;
    protected JTextField textField;
    protected String m_modelName = "";
    private int m_printerCategory;
    protected String m_physicalDeviceDescription = "";
    protected CommandStar m_recPrintMethods = null;
    protected PrinterFont m_recPrinterFont = null;
    protected CommandStarSlip m_slpPrintMethods = null;
    protected PrinterFont m_slpPrinterFont = null;
    private boolean m_lastOutputResult = true;
    protected int m_imageBinarizationThreshold = 128;

    public POSPrinterStarBase(JposEntry jposEntry, boolean[] blArray) throws JposException {
        String string = "";
        String string2 = "";
        this.m_modelName = (String)jposEntry.getPropertyValue("model");
        this.m_printerCategory = ((String)jposEntry.getPropertyValue("printerCategory")).equals("ThermalPrinter") || ((String)jposEntry.getPropertyValue("printerCategory")).equals("DotPrinter") ? 2 : 6;
        if (!jposEntry.hasPropertyWithName("portName") || String.class != jposEntry.getPropertyType("portName")) {
            throw new JposException(104, "A required configuration property (\"portName\" of type String) is missing.");
        }
        this.m_portName = (String)jposEntry.getPropertyValue("portName");
        if (!jposEntry.hasPropertyWithName("portSettings") || String.class != jposEntry.getPropertyType("portSettings")) {
            throw new JposException(104, "A required configuration property (\"portSettings\" of type String) is missing.");
        }
        this.m_portSettings = (String)jposEntry.getPropertyValue("portSettings");
        String string3 = System.getProperty("os.name").toLowerCase();
        if (string3.startsWith("windows")) {
            this.m_portSettings = this.m_portSettings.equals("") ? "PrinterDriver" : this.m_portSettings + ";PrinterDriver";
        }
        if (jposEntry.hasPropertyWithName("ioTimeoutMillis") && Integer.class == jposEntry.getPropertyType("ioTimeoutMillis")) {
            this.m_ioTimeoutMillis = (Integer)jposEntry.getPropertyValue("ioTimeoutMillis");
        }
        if (jposEntry.hasPropertyWithName("ioProgressTimeout") && Integer.class == jposEntry.getPropertyType("ioProgressTimeout")) {
            this.m_ioProgressTimeout = (Integer)jposEntry.getPropertyValue("ioProgressTimeout");
        }
        if (jposEntry.hasPropertyWithName("etbTimeoutMillis") && Integer.class == jposEntry.getPropertyType("etbTimeoutMillis")) {
            this.m_etbTimeoutMillis = (Integer)jposEntry.getPropertyValue("etbTimeoutMillis");
        }
        if (jposEntry.hasPropertyWithName("doCheckedBlockPrinting") && Boolean.class == jposEntry.getPropertyType("doCheckedBlockPrinting")) {
            this.m_doCheckedBlockPrinting = (Boolean)jposEntry.getPropertyValue("doCheckedBlockPrinting");
        }
        if (jposEntry.hasPropertyWithName("imageBinarizationThreshold") && Integer.class == jposEntry.getPropertyType("imageBinarizationThreshold")) {
            this.m_imageBinarizationThreshold = (Integer)jposEntry.getPropertyValue("imageBinarizationThreshold");
            if (this.m_imageBinarizationThreshold < 0 || 255 < this.m_imageBinarizationThreshold) {
                throw new JposException(104, "An invalid value is specified for the property \"imageBinarizationHhreshold\".");
            }
        }
        if (this.m_modelName.equals("TSP100LAN") || this.m_modelName.equals("TSP113LAN") || this.m_modelName.equals("TSP143LAN") || this.m_modelName.equals("TSP143IIILAN") || this.m_modelName.equals("TSP143IIIW")) {
            this.m_doCheckedBlockPrinting = false;
        }
        if (jposEntry.hasPropertyWithName("commandEmulatorConfig") && String.class == jposEntry.getPropertyType("commandEmulatorConfig")) {
            if (((String)jposEntry.getPropertyValue("DBCS")).equals("SJIS")) {
                string = string + "      <setting name=\"Character Set Encoding\" type=\"string\">double byte</setting>      <setting name=\"Double Byte Character Set\" type=\"string\">Japanese</setting>";
            } else if (((String)jposEntry.getPropertyValue("DBCS")).equals("EUC_KR")) {
                string = string + "      <setting name=\"Character Set Encoding\" type=\"string\">double byte</setting>      <setting name=\"Double Byte Character Set\" type=\"string\">Korean</setting>";
            } else if (((String)jposEntry.getPropertyValue("DBCS")).equals("GB2312")) {
                string = string + "      <setting name=\"Character Set Encoding\" type=\"string\">double byte</setting>      <setting name=\"Double Byte Character Set\" type=\"string\">Chinese</setting>";
            } else if (((String)jposEntry.getPropertyValue("DBCS")).equals("GB18030")) {
                string = string + "      <setting name=\"Character Set Encoding\" type=\"string\">double byte</setting>      <setting name=\"Double Byte Character Set\" type=\"string\">Chinese</setting>";
            } else if (((String)jposEntry.getPropertyValue("DBCS")).equals("Big5")) {
                string = string + "      <setting name=\"Character Set Encoding\" type=\"string\">double byte</setting>      <setting name=\"Double Byte Character Set\" type=\"string\">Taiwanese</setting>";
            }
            if (jposEntry.hasPropertyWithName("printableArea") && String.class == jposEntry.getPropertyType("printableArea")) {
                if (72.0 == (Double)jposEntry.getPropertyValue("printableArea")) {
                    string = string + "      <setting name=\"Max Printable Width\" type=\"string\">72mm</setting>";
                    string2 = "    <setting name=\"Paper Width\" type=\"string\">76mm</setting>";
                } else if (51.0 == (Double)jposEntry.getPropertyValue("printableArea")) {
                    string = string + "      <setting name=\"Max Printable Width\" type=\"string\">51mm</setting>";
                    string2 = "    <setting name=\"Paper Width\" type=\"string\">58mm</setting>";
                }
            } else {
                string = string + "      <setting name=\"Max Printable Width\" type=\"string\">72mm</setting>";
                string2 = "    <setting name=\"Paper Width\" type=\"string\">76mm</setting>";
            }
            this.m_commandEmulatorConfig = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?><configuration>  <CommandEmulator>    <setting name=\"Source Emulator Plugin Path\" type=\"string\">StarLineModeSE</setting>    <setting name=\"Target Converter Plugin Path\" type=\"string\">StarTSPTC</setting>  </CommandEmulator>  <StarLineModeSE>    <Defaults>" + string + "    </Defaults>" + "  </StarLineModeSE>" + "  <StarTSPTC>" + "    <setting name=\"Model\" type=\"string\">TSP100</setting>" + string2 + "  </StarTSPTC>" + "</configuration>";
        }
        if (jposEntry.hasPropertyWithName("autoReset") && Boolean.class == jposEntry.getPropertyType("autoReset")) {
            this.m_autoReset = (Boolean)jposEntry.getPropertyValue("autoReset");
        }
        this.m_claimLock = blArray;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void deleteInstance() throws JposException {
        try {
            this.close();
        }
        catch (JposException jposException) {
            // empty catch block
        }
    }

    public String getCheckHealthText() throws JposException {
        return this.m_checkHealthText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getClaimed() throws JposException {
        boolean[] blArray = this.m_claimLock;
        synchronized (this.m_claimLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_claimLock[0];
        }
    }

    public boolean getDeviceEnabled() throws JposException {
        return this.m_deviceEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeviceEnabled(boolean bl) throws JposException {
        this.verifyClaimedState();
        if (this.getState() != 2) {
            throw new JposException(106, "This request failed because the device is busy.");
        }
        if (bl == this.m_deviceEnabled) {
            return;
        }
        if (bl) {
            try {
                this.m_port = StarIOPort.getPort((String)this.m_portName, (String)this.m_portSettings, (int)this.m_ioTimeoutMillis);
                this.m_cachedStatus[0] = this.m_port.retreiveStatus();
            }
            catch (StarIOPortException starIOPortException) {
                throw new JposException(107, "The device communications channel could not be opened, check the device and retry.");
            }
            if (null != this.m_eventThread) {
                return;
            }
            this.m_eventThreadLife = true;
            this.m_eventThread = new Thread(new EventServer());
            this.m_eventThread.start();
            if (null != this.m_statusThread) {
                return;
            }
            this.m_statusThreadLife = true;
            this.m_statusThread = new Thread(new StatusServer());
            this.m_statusThread.start();
            if (null != this.m_outputThread) {
                return;
            }
            this.m_outputThreadLife = true;
            this.m_outputThread = new Thread(new OutputServer());
            this.m_outputThread.start();
            this.m_deviceEnabled = true;
        } else {
            Object object = this.m_asyncOutputLock;
            synchronized (object) {
                this.m_outputThreadLife = false;
                this.m_asyncOutputLock.notifyAll();
            }
            try {
                this.m_outputThread.join();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.m_outputThread = null;
            }
            object = this.m_statusLock;
            synchronized (object) {
                this.m_statusThreadLife = false;
                this.m_statusLock.notifyAll();
            }
            try {
                this.m_statusThread.join();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.m_statusThread = null;
            }
            object = this.m_eventLock;
            synchronized (object) {
                this.m_eventThreadLife = false;
                this.m_eventLock.notifyAll();
            }
            try {
                this.m_eventThread.join();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.m_eventThread = null;
            }
            StarIOPort.releasePort((StarIOPort)this.m_port);
            this.m_port = null;
            this.m_deviceEnabled = false;
        }
    }

    public String getDeviceServiceDescription() throws JposException {
        return "Star Micronics JavaPOS POSPrinter Service Driver";
    }

    public int getDeviceServiceVersion() throws JposException {
        return 1013013;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFreezeEvents() throws JposException {
        Object object = this.m_eventLock;
        synchronized (object) {
            return this.m_freezeEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFreezeEvents(boolean bl) throws JposException {
        Object object = this.m_eventLock;
        synchronized (object) {
            this.m_freezeEvents = bl;
            this.m_eventLock.notifyAll();
        }
    }

    public String getPhysicalDeviceDescription() throws JposException {
        return this.m_physicalDeviceDescription;
    }

    public String getPhysicalDeviceName() throws JposException {
        return "Star Micronics " + this.m_modelName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() throws JposException {
        int[] nArray = this.m_serviceState;
        synchronized (this.m_serviceState) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_serviceState[0];
        }
    }

    public synchronized void open(String string, EventCallbacks eventCallbacks) throws JposException {
        this.m_eventCallbacks = eventCallbacks;
        try {
            if (null != this.m_commandEmulatorConfig) {
                this.m_commandEmulator = new CommandEmulator("XMLConfigurationSet", this.m_commandEmulatorConfig.getBytes());
            }
        }
        catch (Exception exception) {
            throw new JposException(104, "Failed to create the specified CommandEmulator", exception);
        }
        this.setServiceState(2);
    }

    public synchronized void close() throws JposException {
        int n = this.getState();
        if (1 == n) {
            return;
        }
        if (2 != n) {
            throw new JposException(113, "This request is illegal because the service is busy processing asynchronous output.");
        }
        try {
            this.setDeviceEnabled(false);
        }
        catch (JposException jposException) {
            // empty catch block
        }
        try {
            this.release();
        }
        catch (JposException jposException) {
            // empty catch block
        }
        if (null != this.m_port) {
            StarIOPort.releasePort((StarIOPort)this.m_port);
            this.m_port = null;
        }
        this.setServiceState(1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void claim(int n) throws JposException {
        if (-1 > n) {
            throw new JposException(106, "The claim operation was aborted because an invalid timeout parameter was specified.");
        }
        boolean[] blArray = this.m_claimLock;
        synchronized (this.m_claimLock) {
            while (this.m_claimLock[0] && n > 0) {
                try {
                    long l = System.currentTimeMillis();
                    this.m_claimLock.wait(n);
                    long l2 = System.currentTimeMillis() - l;
                    if (l2 > (long)n) {
                        n = 0;
                        continue;
                    }
                    n = (int)((long)n - l2);
                }
                catch (InterruptedException interruptedException) {
                    throw new JposException(106, "The claim operation was aborted because of thread interruption.");
                }
            }
            if (!this.m_claimLock[0]) {
                this.m_claimLock[0] = true;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            throw new JposException(112, "The claim operation timed out");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() throws JposException {
        boolean[] blArray = this.m_claimLock;
        synchronized (this.m_claimLock) {
            if (!this.m_claimLock[0]) {
                throw new JposException(106, "This request is illegal because the service is not already claimed.");
            }
            this.setDeviceEnabled(false);
            this.m_claimLock[0] = false;
            this.m_claimLock.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void checkHealth(int n) throws JposException {
        List list = new ArrayList();
        if (1 == n) {
            throw new JposException(106, "This request failed because the specified checkHealth level is unsupported.");
        }
        if (2 == n) {
            this.verifyDeviceEnabledState();
            this.m_checkHealthText = "Doing checkHealth...\n";
            try {
                if (4 == (this.m_printerCategory & 4)) {
                    this.m_checkHealthText = this.m_checkHealthText + "  checking receipt station...\n";
                    list = this.m_recPrintMethods.parseEscapeSequences(2, this.getCheckHealthData(), false);
                    this.outputData(list);
                    this.m_checkHealthText = this.m_checkHealthText + "    success!\n";
                    this.m_checkHealthText = this.m_checkHealthText + "  checking slip station...\n";
                    list = this.m_slpPrintMethods.parseEscapeSequences(4, this.getCheckHealthData(), false);
                    this.outputData(list);
                    this.m_checkHealthText = this.m_checkHealthText + "    success!\n";
                }
                this.m_checkHealthText = this.m_checkHealthText + "  checking receipt station...\n";
                list = this.m_recPrintMethods.parseEscapeSequences(0, this.getCheckHealthData(), false);
                this.outputData(list);
                this.m_checkHealthText = this.m_checkHealthText + "    success!\n";
            }
            catch (JposException jposException) {
                this.m_checkHealthText = this.m_checkHealthText + "    failure - " + jposException.getMessage() + "\n";
                this.m_checkHealthText = this.m_checkHealthText + "aborted!\n";
                throw jposException;
            }
        } else if (3 == n) {
            JFrame jFrame = new JFrame("JavaPOS POSPrinter");
            jFrame.setState(1);
            jFrame.setExtendedState(1);
            jFrame.setBounds(0, 0, 0, 0);
            jFrame.setResizable(false);
            jFrame.setUndecorated(true);
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            JDialog jDialog = new JDialog(jFrame, "JavaPOS POSPrinter", true);
            jDialog.setSize(350, 210);
            jDialog.setResizable(false);
            Rectangle rectangle = jDialog.getGraphicsConfiguration().getBounds();
            jDialog.setLocation(rectangle.x + rectangle.width / 2 - jDialog.getSize().width / 2, rectangle.y + rectangle.height / 2 - jDialog.getSize().height / 2);
            Container container = jDialog.getContentPane();
            this.radio1 = new JRadioButton("Journal");
            this.radio2 = new JRadioButton("Receipt");
            this.radio3 = new JRadioButton("Slip");
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.radio1);
            buttonGroup.add(this.radio2);
            buttonGroup.add(this.radio3);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            jPanel.add(this.radio1);
            jPanel.add(this.radio2);
            jPanel.add(this.radio3);
            jPanel.setBorder(BorderFactory.createTitledBorder("Station"));
            jPanel.setPreferredSize(new Dimension(325, 100));
            JPanel jPanel2 = new JPanel();
            jPanel2.setPreferredSize(new Dimension(325, 105));
            jPanel2.add((Component)jPanel, "First");
            container.add((Component)jPanel2, "First");
            JPanel jPanel3 = new JPanel();
            this.button = new JButton("CheckHealth");
            this.button.setPreferredSize(new Dimension(323, 28));
            this.button.addActionListener(this);
            jPanel3.add(this.button);
            jDialog.getRootPane().setDefaultButton(this.button);
            container.add((Component)jPanel3, "Center");
            JPanel jPanel4 = new JPanel();
            this.textField = new JTextField("");
            this.textField.setPreferredSize(new Dimension(323, 26));
            this.textField.setEditable(false);
            jPanel4.add(this.textField);
            container.add((Component)jPanel4, "Last");
            this.radio1.setEnabled(false);
            this.radio2.setEnabled(true);
            if (null != this.m_slpPrintMethods) {
                this.radio3.setEnabled(true);
            } else {
                this.radio3.setEnabled(false);
            }
            this.radio2.setSelected(true);
            jDialog.setDefaultCloseOperation(2);
            jFrame.setDefaultCloseOperation(2);
            jFrame.pack();
            jFrame.setVisible(false);
            jDialog.setVisible(true);
            jDialog.hide();
            jFrame.dispose();
        } else {
            throw new JposException(106, "This request failed because the specified command parameter is unsupported.");
        }
    }

    public void directIO(int n, int[] nArray, Object object) throws JposException {
        throw new JposException(106, "This request failed because the specified command parameter is unsupported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPowerNotify() throws JposException {
        int[] nArray = this.m_powerNotifyEnabled;
        synchronized (this.m_powerNotifyEnabled) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_powerNotifyEnabled[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPowerNotify(int n) throws JposException {
        if (this.m_deviceEnabled) {
            throw new JposException(105, "This request is illegal because the service is enabled. ");
        }
        if (n != 0 && n != 1) {
            throw new JposException(106, "This request is illegal because the powerNotify parameter is unsupported.");
        }
        int[] nArray = this.m_powerNotifyEnabled;
        synchronized (this.m_powerNotifyEnabled) {
            this.m_powerNotifyEnabled[0] = n;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPowerState() throws JposException {
        int[] nArray = this.m_powerState;
        synchronized (this.m_powerState) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_powerState[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPowerState(int n) {
        int[] nArray = this.m_powerState;
        synchronized (this.m_powerState) {
            this.m_powerState[0] = n;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void outputData(List var1_1) throws JposException {
        var2_2 = this.m_port;
        synchronized (var2_2) {
            block35: {
                block34: {
                    try {
                        if (this.m_doCheckedBlockPrinting) {
                            var3_3 = this.m_port.beginCheckedBlock();
                            if (this.m_commandEmulatorConfig == null) {
                                var1_1.add(0, new byte[]{27, 29, 3, 3, 0, 0});
                                var1_1.add(var1_1.size(), new byte[]{27, 29, 3, 4, 0, 0});
                            }
                            break block34;
                        }
                        var3_3 = this.m_port.retreiveStatus();
                    }
                    catch (StarIOPortException var4_4) {
                        if (1 != this.getPowerNotify()) throw new JposException(107, "This print operation failed because device communication failed.");
                        if (2002 == this.getPowerState()) throw new JposException(107, "This print operation failed because device communication failed.");
                        this.setPowerState(2002);
                        this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2002));
                        throw new JposException(107, "This print operation failed because device communication failed.");
                    }
                }
                if (1 == this.getPowerNotify()) {
                    if (var3_3.offline) {
                        if (2003 != this.getPowerState()) {
                            this.setPowerState(2003);
                            this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2003));
                        }
                    } else if (2002 == this.getPowerState()) {
                        this.setPowerState(2003);
                        this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2003));
                    }
                }
                this.updateStatus(var3_3);
                if (1 == this.getPowerNotify() && !var3_3.offline && 2001 != this.getPowerState()) {
                    this.setPowerState(2001);
                    this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2001));
                }
                if (var3_3.offline) {
                    throw new JposException(108, "This print operation failed because the device is offline.");
                }
                try {
                    var4_5 = 0;
                    var5_9 = null;
                    var6_11 = 0;
                    for (var7_13 = 0; var7_13 < var1_1.size(); var4_5 += var8_17.length, ++var7_13) {
                        var8_17 = (byte[])var1_1.get(var7_13);
                    }
                    var5_9 = new byte[var4_5];
                    for (var7_13 = 0; var7_13 < var1_1.size(); var6_11 += var8_17.length, ++var7_13) {
                        var8_17 = (byte[])var1_1.get(var7_13);
                        System.arraycopy(var8_17, 0, var5_9, var6_11, var8_17.length);
                    }
                    if (null != this.m_commandEmulator) {
                        try {
                            var5_9 = this.m_commandEmulator.emulate(var5_9, var5_9.length);
                        }
                        catch (Exception var7_14) {
                            throw new JposException(106, "CommandEmulator Error");
                        }
                        if (this.m_doCheckedBlockPrinting) {
                            var7_15 = new byte[]{27, 29, 3, 3, 0, 0};
                            var8_17 = new byte[]{27, 29, 3, 4, 0, 0};
                            var9_19 = new byte[var7_15.length + var5_9.length + var8_17.length];
                            System.arraycopy(var7_15, 0, var9_19, 0, var7_15.length);
                            System.arraycopy(var5_9, 0, var9_19, var7_15.length, var5_9.length);
                            System.arraycopy(var8_17, 0, var9_19, var7_15.length + var5_9.length, var8_17.length);
                            var5_9 = var9_19;
                        }
                    }
                    if (null != var5_9) {
                        var7_16 = System.currentTimeMillis();
                        for (var9_20 = 0; System.currentTimeMillis() - var7_16 < (long)this.m_ioProgressTimeout && var9_20 < var5_9.length; var9_20 += var10_21) {
                            var10_21 = this.m_port.writePort(var5_9, var9_20, var5_9.length - var9_20);
                            if (0 == var10_21) continue;
                            var7_16 = System.currentTimeMillis();
                        }
                        if (var9_20 < var5_9.length) {
                            this.updateStatus();
                            throw new JposException(112);
                        }
                    }
                }
                catch (StarIOPortException var4_6) {
                    this.updateStatus();
                    throw new JposException(112);
                }
                if (this.m_doCheckedBlockPrinting) {
                    try {
                        if ((this.m_modelName.startsWith("TUP5") || this.m_modelName.startsWith("TUP9")) && this.m_autoReset) {
                            var4_7 = new byte[]{23, 23};
                            var5_10 = 0;
                            var5_10 = this.m_port.writePort(var4_7, 0, var4_7.length);
                            if (2 != var5_10) {
                                throw new JposException(112);
                            }
                            var6_12 = System.currentTimeMillis();
                            break block35;
                        }
                        var3_3 = this.m_port.endCheckedBlock();
                        this.updateStatus(var3_3);
                        if (var3_3.offline) {
                            throw new StarIOPortException("printer offline");
                        }
                    }
                    catch (StarIOPortException var4_8) {
                        if (this.getPowerNotify() != 1) throw new JposException(107, "This print operation failed because device communication failed.");
                        if (this.getPowerState() == 2002) throw new JposException(107, "This print operation failed because device communication failed.");
                        this.setPowerState(2002);
                        this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2002));
                        throw new JposException(107, "This print operation failed because device communication failed.");
                    }
                }
lbl95:
                // 5 sources

                while (true) {
                    this.m_lastOutputResult = true;
                    return;
                }
            }
            do {
                block36: {
                    var3_3 = this.m_port.retreiveStatus();
                    if (!var3_3.offline) break block36;
                    this.m_port.resetDevice();
                    ** GOTO lbl95
                }
                if (2 != var3_3.etbCounter) ** break;
                ** continue;
                try {
                    Thread.sleep(200L);
                }
                catch (Exception var8_18) {
                    // empty catch block
                }
            } while ((long)this.m_etbTimeoutMillis >= System.currentTimeMillis() - var6_12);
            this.m_port.resetDevice();
            throw new JposException(112, "All data was sent but not all was printed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStatus() throws JposException {
        StarIOPort starIOPort = this.m_port;
        synchronized (starIOPort) {
            StarPrinterStatus starPrinterStatus;
            try {
                starPrinterStatus = this.m_port.retreiveStatus();
            }
            catch (StarIOPortException starIOPortException) {
                if (1 == this.getPowerNotify() && 2002 != this.getPowerState()) {
                    this.setPowerState(2002);
                    this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2002));
                }
                throw new JposException(107, "This print operation failed because device communication failed.");
            }
            if (1 == this.getPowerNotify()) {
                if (starPrinterStatus.offline) {
                    if (2003 != this.getPowerState()) {
                        this.setPowerState(2003);
                        this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2003));
                    }
                } else if (2002 == this.getPowerState()) {
                    this.setPowerState(2003);
                    this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2003));
                }
            }
            try {
                this.updateStatus(starPrinterStatus);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (this.getPowerNotify() == 1 && !starPrinterStatus.offline && 2001 != this.getPowerState()) {
                    this.setPowerState(2001);
                    this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2001));
                }
                if (!(starPrinterStatus.offline || starPrinterStatus.coverOpen || starPrinterStatus.receiptPaperNearEmptyInner || starPrinterStatus.receiptPaperEmpty || starPrinterStatus.receiveBufferOverflow || 4 != this.getState())) {
                    this.setErrorLevel(1, 2, "");
                    this.setServiceState(2);
                }
                throw throwable;
            }
            if (this.getPowerNotify() == 1 && !starPrinterStatus.offline && 2001 != this.getPowerState()) {
                this.setPowerState(2001);
                this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2001));
            }
            if (!(starPrinterStatus.offline || starPrinterStatus.coverOpen || starPrinterStatus.receiptPaperNearEmptyInner || starPrinterStatus.receiptPaperEmpty || starPrinterStatus.receiveBufferOverflow || 4 != this.getState())) {
                this.setErrorLevel(1, 2, "");
                this.setServiceState(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStatus(StarPrinterStatus starPrinterStatus) throws JposException {
        StarPrinterStatus[] starPrinterStatusArray = this.m_cachedStatus;
        synchronized (this.m_cachedStatus) {
            if (this.getPowerNotify() == 1) {
                if (starPrinterStatus.offline) {
                    if (this.getPowerState() != 2003) {
                        this.setPowerState(2003);
                        this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2003));
                    }
                } else if (this.getPowerState() != 2001) {
                    this.setPowerState(2001);
                    this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 2001));
                }
            }
            StarPrinterStatus starPrinterStatus2 = this.m_cachedStatus[0];
            this.m_cachedStatus[0] = starPrinterStatus;
            if (starPrinterStatus.coverOpen) {
                if (!starPrinterStatus2.coverOpen) {
                    this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 11));
                }
            } else if (starPrinterStatus2.coverOpen) {
                this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 12));
            }
            if (starPrinterStatus.receiptPaperEmpty) {
                if (!starPrinterStatus2.receiptPaperEmpty) {
                    this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 24));
                }
            } else if (starPrinterStatus.receiptPaperNearEmptyInner) {
                if (starPrinterStatus2.receiptPaperEmpty || !starPrinterStatus2.receiptPaperNearEmptyInner) {
                    this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 25));
                }
            } else if (starPrinterStatus2.receiptPaperEmpty || starPrinterStatus2.receiptPaperNearEmptyInner) {
                this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 26));
            }
            if (starPrinterStatus.coverOpen) {
                throw new JposException(114, 201, "This print request failed because the device's cover is open.");
            }
            if (starPrinterStatus.receiptPaperEmpty) {
                throw new JposException(114, 203, "This print request failed because the device is out of paper.");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyClaimedState() throws JposException {
        boolean[] blArray = this.m_claimLock;
        synchronized (this.m_claimLock) {
            if (!this.m_claimLock[0]) {
                throw new JposException(103, "The service is not claimed.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void verifyDeviceEnabledState() throws JposException {
        this.verifyClaimedState();
        if (!this.m_deviceEnabled) {
            throw new JposException(105, "The service is not enabled.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setServiceState(int n) {
        int[] nArray = this.m_serviceState;
        synchronized (this.m_serviceState) {
            if (this.m_serviceState[0] == n) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.m_serviceState[0] = n;
            if (this.m_serviceState[0] != 4) {
                this.m_errorString = "";
            }
            if (this.m_serviceState[0] == 2 && this.m_flagWhenIdle) {
                this.m_flagWhenIdle = false;
                this.addEvent((JposEvent)new StatusUpdateEvent((Object)this, 1001));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAsyncOutput(List list) throws JposException {
        Object object = this.m_asyncOutputLock;
        synchronized (object) {
            if (9999 < this.m_outputId) {
                this.m_outputId = 0;
            }
            ++this.m_outputId;
            this.m_asyncOutputQueue.add(new AsyncOutputDataStruct(list, this.m_outputId));
            this.setServiceState(3);
            this.m_asyncOutputLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AsyncOutputDataStruct retreiveAsyncOutputOrDie() {
        Object object = this.m_asyncOutputLock;
        synchronized (object) {
            while ((this.m_asyncOutputQueue.isEmpty() || this.m_clearOutputPending) && this.m_outputThreadLife) {
                try {
                    this.m_asyncOutputLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
            if (!this.m_outputThreadLife) {
                return null;
            }
            this.m_processingAsyncOutput = true;
            return (AsyncOutputDataStruct)this.m_asyncOutputQueue.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firstAsyncOutputProcessed(boolean bl) {
        Object object = this.m_asyncOutputLock;
        synchronized (object) {
            this.m_processingAsyncOutput = false;
            AsyncOutputDataStruct asyncOutputDataStruct = (AsyncOutputDataStruct)this.m_asyncOutputQueue.remove(0);
            if (bl) {
                this.addEvent((JposEvent)new OutputCompleteEvent((Object)this, asyncOutputDataStruct.getOutputID()));
            }
            if (this.m_asyncOutputQueue.isEmpty()) {
                this.setServiceState(2);
            } else {
                this.setServiceState(3);
            }
            this.m_asyncOutputLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEvent(JposEvent jposEvent) {
        Object object = this.m_eventLock;
        synchronized (object) {
            this.m_eventQueue.add(jposEvent);
            this.m_eventLock.notifyAll();
        }
    }

    protected String getCheckHealthData() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u001b|N");
        stringBuffer.append("\u001b|bC" + this.m_modelName + " - CheckHealth" + '\n');
        stringBuffer.append("\u001b|bC-------------------------------\n");
        stringBuffer.append('\n');
        stringBuffer.append("\u001b|N\u001b|bCbold\n");
        stringBuffer.append("\u001b|N\u001b|uCunderline\n");
        stringBuffer.append("\u001b|N\u001b|rvCreverse\n");
        stringBuffer.append("\u001b|N\u001b|2C2x wide\n");
        stringBuffer.append("\u001b|N\u001b|3C2x high\n");
        stringBuffer.append("\u001b|N\u001b|4C2x wide 2x high\n");
        stringBuffer.append("\u001b|N\u001b|cAcenter alignment\n");
        stringBuffer.append("\u001b|N\u001b|rAright aligment\n");
        stringBuffer.append("\u001b|Nnormal\n");
        stringBuffer.append("\u001b|50fP");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setErrorLevel(int n, int n2, String string) {
        int[] nArray = this.m_serviceState;
        synchronized (this.m_serviceState) {
            if (1 != n) {
                this.setServiceState(4);
            }
            this.m_errorLevel = n;
            this.m_errorStation = n2;
            this.m_errorString = string;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.button)) {
            try {
                this.verifyDeviceEnabledState();
                if (this.radio2.isSelected()) {
                    this.m_checkHealthText = this.m_checkHealthText + "  checking receipt station...\n";
                    List list = this.m_recPrintMethods.parseEscapeSequences(0, this.getCheckHealthData(), false);
                    this.outputData(list);
                }
            }
            catch (JposException jposException) {
                this.m_checkHealthText = this.m_checkHealthText + "    failure - " + jposException.getMessage() + "\n";
                this.m_checkHealthText = this.m_checkHealthText + "aborted!\n";
                block1 : switch (jposException.getErrorCode()) {
                    case 0: {
                        this.textField.setText("JPOS_SUCCESS");
                        break;
                    }
                    case 101: {
                        this.textField.setText("JPOS_E_CLOSED");
                        break;
                    }
                    case 102: {
                        this.textField.setText("JPOS_E_CLAIMED");
                        break;
                    }
                    case 103: {
                        this.textField.setText("JPOS_E_NOTCLAIMED");
                        break;
                    }
                    case 104: {
                        this.textField.setText("JPOS_E_NOSERVICE");
                        break;
                    }
                    case 105: {
                        this.textField.setText("JPOS_E_DISABLED");
                        break;
                    }
                    case 106: {
                        this.textField.setText("JPOS_E_ILLEGAL");
                        break;
                    }
                    case 107: {
                        this.textField.setText("JPOS_E_NOHARDWARE");
                        break;
                    }
                    case 108: {
                        this.textField.setText("JPOS_E_OFFLINE");
                        break;
                    }
                    case 109: {
                        this.textField.setText("JPOS_E_NOEXIST");
                        break;
                    }
                    case 110: {
                        this.textField.setText("JPOS_E_EXISTS");
                        break;
                    }
                    case 111: {
                        this.textField.setText("JPOS_E_FAILURE");
                        break;
                    }
                    case 112: {
                        this.textField.setText("JPOS_E_TIMEOUT");
                        break;
                    }
                    case 113: {
                        this.textField.setText("JPOS_E_BUSY");
                        break;
                    }
                    case 114: {
                        switch (jposException.getErrorCodeExtended()) {
                            case 201: {
                                this.textField.setText("JPOS_E_EXTENDED(JPOS_EPTR_COVER_OPEN)");
                                break block1;
                            }
                            case 202: {
                                this.textField.setText("JPOS_E_EXTENDED(JPOS_EPTR_JRN_EMPTY)");
                                break block1;
                            }
                            case 203: {
                                this.textField.setText("JPOS_E_EXTENDED(JPOS_EPTR_REC_EMPTY)");
                                break block1;
                            }
                            case 204: {
                                this.textField.setText("JPOS_E_EXTENDED(JPOS_EPTR_SLP_EMPTY)");
                                break block1;
                            }
                        }
                        this.textField.setText("ResultCode Error !?");
                        break;
                    }
                    default: {
                        this.textField.setText("ResultCode Error !?");
                    }
                }
                return;
            }
            this.m_checkHealthText = this.m_checkHealthText + "    success!\n";
            this.textField.setText("JPOS_SUCCESS");
        }
    }

    protected class WaitableErrorEvent
    extends ErrorEvent {
        private boolean errorResponseSet;

        public WaitableErrorEvent(Object object, int n, int n2, int n3, int n4) {
            super(object, n, n2, n3, n4);
            this.errorResponseSet = false;
        }

        public synchronized void setErrorResponse(int n) {
            if (11 != n && 12 != n) {
                n = 12;
            }
            this.errorResponse = n;
            this.errorResponseSet = true;
            ((Object)((Object)this)).notifyAll();
        }

        public synchronized int getErrorResponse() {
            while (!this.errorResponseSet) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {
                    this.errorResponse = 12;
                    this.errorResponseSet = true;
                }
            }
            return this.errorResponse;
        }
    }

    protected class StatusServer
    implements Runnable {
        protected StatusServer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object = POSPrinterStarBase.this.m_statusLock;
                synchronized (object) {
                    if (!POSPrinterStarBase.this.m_statusThreadLife) {
                        break;
                    }
                }
                try {
                    if (POSPrinterStarBase.this.m_modelName.startsWith("MCP") && (POSPrinterStarBase.this.m_portName.startsWith("usbprn:") || POSPrinterStarBase.this.m_portName.startsWith("tcp:"))) {
                        POSPrinterStarBase.this.m_port.writePort(new byte[]{0}, 0, 1);
                    }
                    POSPrinterStarBase.this.updateStatus();
                }
                catch (JposException jposException) {
                }
                catch (StarIOPortException starIOPortException) {
                    // empty catch block
                }
                object = POSPrinterStarBase.this.m_statusLock;
                synchronized (object) {
                    try {
                        if (POSPrinterStarBase.this.m_modelName.startsWith("SM-S") || POSPrinterStarBase.this.m_modelName.startsWith("SM-T") || POSPrinterStarBase.this.m_modelName.startsWith("SM-L")) {
                            POSPrinterStarBase.this.m_statusLock.wait(5000L);
                        } else {
                            POSPrinterStarBase.this.m_statusLock.wait(1000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected class EventServer
    implements Runnable {
        protected EventServer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                JposEvent jposEvent = null;
                Object object = POSPrinterStarBase.this.m_eventLock;
                synchronized (object) {
                    while ((POSPrinterStarBase.this.m_freezeEvents || POSPrinterStarBase.this.m_eventQueue.isEmpty()) && POSPrinterStarBase.this.m_eventThreadLife) {
                        try {
                            POSPrinterStarBase.this.m_eventLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    if (!POSPrinterStarBase.this.m_eventThreadLife) {
                        return;
                    }
                    jposEvent = (JposEvent)POSPrinterStarBase.this.m_eventQueue.remove(0);
                }
                if (jposEvent instanceof StatusUpdateEvent) {
                    POSPrinterStarBase.this.m_eventCallbacks.fireStatusUpdateEvent((StatusUpdateEvent)jposEvent);
                    continue;
                }
                if (jposEvent instanceof OutputCompleteEvent) {
                    POSPrinterStarBase.this.m_eventCallbacks.fireOutputCompleteEvent((OutputCompleteEvent)jposEvent);
                    continue;
                }
                if (jposEvent instanceof DataEvent) {
                    POSPrinterStarBase.this.m_eventCallbacks.fireDataEvent((DataEvent)jposEvent);
                    continue;
                }
                if (jposEvent instanceof ErrorEvent) {
                    POSPrinterStarBase.this.m_eventCallbacks.fireErrorEvent((ErrorEvent)jposEvent);
                    continue;
                }
                if (!(jposEvent instanceof DirectIOEvent)) continue;
                POSPrinterStarBase.this.m_eventCallbacks.fireDirectIOEvent((DirectIOEvent)jposEvent);
            }
        }
    }

    protected class OutputServer
    implements Runnable {
        protected OutputServer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                AsyncOutputDataStruct asyncOutputDataStruct = null;
                Object object = POSPrinterStarBase.this.m_asyncOutputLock;
                synchronized (object) {
                    while ((POSPrinterStarBase.this.m_asyncOutputQueue.isEmpty() || POSPrinterStarBase.this.m_clearOutputPending) && POSPrinterStarBase.this.m_outputThreadLife) {
                        try {
                            if (POSPrinterStarBase.this.m_asyncOutputQueue.isEmpty()) {
                                POSPrinterStarBase.this.m_asyncOutputLock.wait();
                                continue;
                            }
                            POSPrinterStarBase.this.m_clearOutputPending = false;
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    if (!POSPrinterStarBase.this.m_outputThreadLife && POSPrinterStarBase.this.m_lastOutputResult) {
                        return;
                    }
                    POSPrinterStarBase.this.m_processingAsyncOutput = true;
                    asyncOutputDataStruct = (AsyncOutputDataStruct)POSPrinterStarBase.this.m_asyncOutputQueue.get(0);
                    POSPrinterStarBase.this.m_asyncOutputLock.notifyAll();
                }
                try {
                    POSPrinterStarBase.this.outputData(asyncOutputDataStruct.getAsyncOutputByteList());
                    POSPrinterStarBase.this.firstAsyncOutputProcessed(true);
                    continue;
                }
                catch (JposException jposException) {
                    POSPrinterStarBase.this.m_lastOutputResult = false;
                    POSPrinterStarBase.this.setErrorLevel(2, 2, jposException.getMessage());
                    WaitableErrorEvent waitableErrorEvent = new WaitableErrorEvent(this, jposException.getErrorCode(), jposException.getErrorCodeExtended(), 1, 12);
                    POSPrinterStarBase.this.addEvent((JposEvent)waitableErrorEvent);
                    if (12 != waitableErrorEvent.getErrorResponse()) continue;
                    POSPrinterStarBase.this.firstAsyncOutputProcessed(false);
                    POSPrinterStarBase.this.setErrorLevel(1, 2, "");
                    continue;
                }
                break;
            }
        }
    }
}

