/*
 * Decompiled with CFR 0.152.
 */
package com.starmicronics.starjavapos;

import com.starmicronics.starjavapos.ESCPOS.CashDrawerESCPOSService;
import com.starmicronics.starjavapos.ESCPOS.MICRESCPOSService;
import com.starmicronics.starjavapos.ESCPOS.POSPrinterESCPOSDot;
import com.starmicronics.starjavapos.ESCPOS.POSPrinterESCPOSThermal;
import com.starmicronics.starjavapos.Star.CashDrawerStarService;
import com.starmicronics.starjavapos.Star.MICRStarService;
import com.starmicronics.starjavapos.Star.POSPrinterStarDot;
import com.starmicronics.starjavapos.Star.POSPrinterStarHybrid;
import com.starmicronics.starjavapos.Star.POSPrinterStarThermal;
import java.util.HashMap;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.loader.JposServiceInstance;
import jpos.loader.JposServiceInstanceFactory;

public class ServiceInstanceFactory
implements JposServiceInstanceFactory {
    private HashMap m_printerClaimLocks = new HashMap();
    private HashMap m_cashDrawerClaimLocks = new HashMap();
    private HashMap m_MICRClaimLocks = new HashMap();
    private JposEntry m_config;
    private static final int FULLCUT = 1;
    private static final int PARTIALCUT = 2;
    private static final int NEAREND = 4;
    private static final int FONTB = 8;
    private static final int DOTLINEWIDTH = 16;
    private static final int CAP2COLOR = 32;
    private static final int CAP18PIN = 64;
    private static final int COVEROPEN = 128;

    public JposServiceInstance createInstance(String string, JposEntry jposEntry) throws JposException {
        this.m_config = jposEntry;
        if (!jposEntry.hasPropertyWithName("deviceCategory") || jposEntry.getPropertyType("deviceCategory") != String.class) {
            throw new JposException(104, "A required configuration property (\"category\" of type String) is missing.");
        }
        String string2 = (String)jposEntry.getPropertyValue("deviceCategory");
        if (string2.equals("POSPrinter")) {
            if (!jposEntry.hasPropertyWithName("model") || jposEntry.getPropertyType("model") != String.class) {
                throw new JposException(104, "A required configuration property (\"model\" of type String) is missing.");
            }
            String string3 = (String)jposEntry.getPropertyValue("model");
            boolean[] blArray = (boolean[])this.m_printerClaimLocks.get(string);
            if (null == blArray) {
                blArray = new boolean[1];
                this.m_printerClaimLocks.put(string, blArray);
            }
            if (jposEntry.hasPropertyWithName("DBCS") && String.class == jposEntry.getPropertyType("DBCS")) {
                if (!(((String)jposEntry.getPropertyValue("DBCS")).equals("SJIS") || ((String)jposEntry.getPropertyValue("DBCS")).equals("EUC_KR") || ((String)jposEntry.getPropertyValue("DBCS")).equals("GB2312") || ((String)jposEntry.getPropertyValue("DBCS")).equals("GB18030") || ((String)jposEntry.getPropertyValue("DBCS")).equals("Big5") || ((String)jposEntry.getPropertyValue("DBCS")).equals(""))) {
                    throw new JposException(104, "A required configuration property (\"DBCS\" of type String) is invalid.");
                }
            } else {
                jposEntry.addProperty("DBCS", (Object)String.valueOf(""));
            }
            if (jposEntry.hasPropertyWithName("emulation")) {
                if (jposEntry.getPropertyType("emulation") != String.class) {
                    throw new JposException(104, "A required configuration property (\"emulation\" is not String type.");
                }
                String string4 = (String)jposEntry.getPropertyValue("emulation");
                if (string4.equals("ESC/POS")) {
                    if (this.validateThermalPrinterModel(string3)) {
                        return new POSPrinterESCPOSThermal(this.m_config, blArray);
                    }
                    if (this.validateDotPrinterModel(string3)) {
                        return new POSPrinterESCPOSDot(this.m_config, blArray);
                    }
                    throw new JposException(104, "The specified model is unsupported.");
                }
                if (string4.equals("StarLine")) {
                    if (this.validateThermalPrinterModel(string3)) {
                        return new POSPrinterStarThermal(this.m_config, blArray);
                    }
                    if (this.validateDotPrinterModel(string3)) {
                        return new POSPrinterStarDot(this.m_config, blArray);
                    }
                    if (this.validateHybridPrinterModel(string3)) {
                        return new POSPrinterStarHybrid(this.m_config, blArray);
                    }
                    throw new JposException(104, "The specified model is unsupported.");
                }
                throw new JposException(104, "A required configuration property (\"emulation\" is not \"StarLine\" or \"ESC/POS\".");
            }
            if (this.validateThermalPrinterModel(string3)) {
                return new POSPrinterStarThermal(this.m_config, blArray);
            }
            if (this.validateDotPrinterModel(string3)) {
                return new POSPrinterStarDot(this.m_config, blArray);
            }
            if (this.validateHybridPrinterModel(string3)) {
                return new POSPrinterStarHybrid(this.m_config, blArray);
            }
            throw new JposException(104, "The specified model is unsupported.");
        }
        if (string2.equals("CashDrawer")) {
            boolean[] blArray = (boolean[])this.m_cashDrawerClaimLocks.get(string);
            if (null == blArray) {
                blArray = new boolean[1];
                this.m_cashDrawerClaimLocks.put(string, blArray);
            }
            if (jposEntry.hasPropertyWithName("emulation")) {
                if (jposEntry.getPropertyType("emulation") != String.class) {
                    throw new JposException(104, "A required configuration property (\"emulation\" is not String type.");
                }
                String string5 = (String)jposEntry.getPropertyValue("emulation");
                if (string5.equals("ESC/POS")) {
                    return new CashDrawerESCPOSService(jposEntry, blArray);
                }
                if (string5.equals("StarLine")) {
                    return new CashDrawerStarService(jposEntry, blArray);
                }
                throw new JposException(104, "A required configuration property (\"emulation\" is not \"StarLine\" or \"ESC/POS\".");
            }
            return new CashDrawerStarService(jposEntry, blArray);
        }
        if (string2.equals("MICR")) {
            boolean[] blArray = (boolean[])this.m_MICRClaimLocks.get(string);
            if (null == blArray) {
                blArray = new boolean[1];
                this.m_MICRClaimLocks.put(string, blArray);
            }
            if (jposEntry.hasPropertyWithName("emulation")) {
                if (jposEntry.getPropertyType("emulation") != String.class) {
                    throw new JposException(104, "A required configuration property (\"emulation\" is not String type.");
                }
                String string6 = (String)jposEntry.getPropertyValue("emulation");
                if (string6.equals("ESC/POS")) {
                    return new MICRESCPOSService(jposEntry, blArray);
                }
                if (string6.equals("StarLine")) {
                    return new MICRStarService(jposEntry, blArray);
                }
                throw new JposException(104, "A required configuration property (\"emulation\" is not \"StarLine\" or \"ESC/POS\".");
            }
            return new MICRStarService(jposEntry, blArray);
        }
        throw new JposException(104, "The specified device category is not supported.");
    }

    private boolean validateThermalPrinterModel(String string) {
        if (string.equals("TSP100") || string.equals("TSP100GT") || string.equals("TSP100LAN") || string.equals("TSP113") || string.equals("TSP113GT") || string.equals("TSP113LAN") || string.equals("TSP143") || string.equals("TSP143GT") || string.equals("TSP143LAN") || string.equals("TSP143IIILAN") || string.equals("TSP143IIIW") || string.equals("TSP143IIIBI") || string.equals("TSP100IIIBI")) {
            this.removeProperty(29);
            this.m_config.addProperty("fullCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("nearEndSensor", (Object)Boolean.FALSE);
            this.m_config.addProperty("fontB", (Object)Boolean.FALSE);
            if (string.equals("TSP113") || string.equals("TSP113GT") || string.equals("TSP113LAN")) {
                this.removeProperty(2);
                this.m_config.addProperty("partialCut", (Object)Boolean.FALSE);
            } else if (string.equals("TSP143") || string.equals("TSP143GT") || string.equals("TSP143LAN")) {
                this.removeProperty(2);
                this.m_config.addProperty("partialCut", (Object)Boolean.TRUE);
            } else if (this.m_config.hasPropertyWithName("partialCut")) {
                if (this.m_config.getPropertyType("partialCut") != Boolean.class) {
                    // empty if block
                }
            } else {
                this.m_config.addProperty("partialCut", (Object)Boolean.TRUE);
            }
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class) {
                    if (72.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
                    } else if (51.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("408"));
                    }
                }
            } else {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
            }
        } else if (string.equals("TSP600") || string.equals("TSP613") || string.equals("TSP643")) {
            this.removeProperty(29);
            this.m_config.addProperty("fullCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("nearEndSensor", (Object)Boolean.TRUE);
            this.m_config.addProperty("fontB", (Object)Boolean.FALSE);
            if (string.equals("TSP613")) {
                this.removeProperty(2);
                this.m_config.addProperty("partialCut", (Object)Boolean.FALSE);
            } else if (string.equals("TSP643")) {
                this.removeProperty(2);
                this.m_config.addProperty("partialCut", (Object)Boolean.TRUE);
            } else if (this.m_config.hasPropertyWithName("partialCut")) {
                if (this.m_config.getPropertyType("partialCut") != Boolean.class) {
                    // empty if block
                }
            } else {
                this.m_config.addProperty("partialCut", (Object)Boolean.TRUE);
            }
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class) {
                    if (72.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
                    } else if (50.8 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("406"));
                    }
                }
            } else {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
            }
        } else if (string.equals("TSP650") || string.equals("TSP651") || string.equals("TSP654") || string.equals("TSP650II")) {
            this.removeProperty(29);
            this.m_config.addProperty("fullCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("nearEndSensor", (Object)Boolean.TRUE);
            this.m_config.addProperty("fontB", (Object)Boolean.TRUE);
            if (string.equals("TSP651")) {
                this.removeProperty(2);
                this.m_config.addProperty("partialCut", (Object)Boolean.FALSE);
            } else if (string.equals("TSP654")) {
                this.removeProperty(2);
                this.m_config.addProperty("partialCut", (Object)Boolean.TRUE);
            } else if (this.m_config.hasPropertyWithName("partialCut")) {
                if (this.m_config.getPropertyType("partialCut") != Boolean.class) {
                    // empty if block
                }
            } else {
                this.m_config.addProperty("partialCut", (Object)Boolean.TRUE);
            }
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class) {
                    if (72.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
                    } else if (50.8 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("406"));
                    }
                }
            } else {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
            }
        } else if (string.equals("TSP700") || string.equals("TSP743")) {
            this.removeProperty(31);
            this.m_config.addProperty("fullCut", (Object)Boolean.TRUE);
            this.m_config.addProperty("partialCut", (Object)Boolean.TRUE);
            this.m_config.addProperty("nearEndSensor", (Object)Boolean.TRUE);
            this.m_config.addProperty("fontB", (Object)Boolean.FALSE);
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class) {
                    if (80.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("640"));
                    } else if (72.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
                    } else if (50.8 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("406"));
                    }
                }
            } else {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
            }
        } else if (string.equals("TSP700II") || string.equals("TSP743II")) {
            this.removeProperty(31);
            this.m_config.addProperty("fullCut", (Object)Boolean.TRUE);
            this.m_config.addProperty("partialCut", (Object)Boolean.TRUE);
            this.m_config.addProperty("nearEndSensor", (Object)Boolean.TRUE);
            this.m_config.addProperty("fontB", (Object)Boolean.TRUE);
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class) {
                    if (80.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("640"));
                    } else if (72.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
                    } else if (50.8 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("406"));
                    }
                }
            } else {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
            }
        } else if (string.equals("TSP800") || string.equals("TSP847")) {
            this.removeProperty(31);
            this.m_config.addProperty("fullCut", (Object)Boolean.TRUE);
            this.m_config.addProperty("partialCut", (Object)Boolean.TRUE);
            this.m_config.addProperty("nearEndSensor", (Object)Boolean.TRUE);
            this.m_config.addProperty("fontB", (Object)Boolean.FALSE);
            this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("832"));
        } else if (string.equals("TSP800II") || string.equals("TSP847II")) {
            this.removeProperty(31);
            this.m_config.addProperty("fullCut", (Object)Boolean.TRUE);
            this.m_config.addProperty("partialCut", (Object)Boolean.TRUE);
            this.m_config.addProperty("nearEndSensor", (Object)Boolean.TRUE);
            this.m_config.addProperty("fontB", (Object)Boolean.TRUE);
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class) {
                    if (104.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("832"));
                    } else if (72.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
                    }
                }
            } else {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("832"));
            }
        } else if (string.equals("TSP1000") || string.equals("TSP1043") || string.equals("TSP1045")) {
            this.removeProperty(31);
            this.m_config.addProperty("fullCut", (Object)Boolean.TRUE);
            this.m_config.addProperty("partialCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("nearEndSensor", (Object)Boolean.TRUE);
            this.m_config.addProperty("fontB", (Object)Boolean.TRUE);
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class) {
                    if (80.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("640"));
                    } else if (72.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
                    }
                }
            } else if (string.equals("TSP1043")) {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
            } else {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("640"));
            }
        } else if (string.equals("TUP500") || string.equals("TUP542") || string.equals("TUP592")) {
            this.removeProperty(31);
            this.m_config.addProperty("fullCut", (Object)Boolean.TRUE);
            this.m_config.addProperty("partialCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("nearEndSensor", (Object)Boolean.TRUE);
            this.m_config.addProperty("fontB", (Object)Boolean.TRUE);
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class) {
                    if (80.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("640"));
                    } else if (72.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
                    }
                }
            } else {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
            }
        } else if (string.equals("TUP900") || string.equals("TUP992")) {
            this.removeProperty(31);
            this.m_config.addProperty("fullCut", (Object)Boolean.TRUE);
            this.m_config.addProperty("partialCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("nearEndSensor", (Object)Boolean.TRUE);
            this.m_config.addProperty("fontB", (Object)Boolean.FALSE);
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class) {
                    if (104.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("832"));
                    } else if (80.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("640"));
                    } else if (72.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
                    }
                }
            } else {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("832"));
            }
        } else if (string.equals("FVP10")) {
            this.removeProperty(31);
            this.m_config.addProperty("fullCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("partialCut", (Object)Boolean.TRUE);
            this.m_config.addProperty("nearEndSensor", (Object)Boolean.TRUE);
            this.m_config.addProperty("fontB", (Object)Boolean.TRUE);
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class) {
                    if (72.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
                    } else if (50.8 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("406"));
                    }
                }
            } else {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
            }
        } else if (string.equals("SM-T300i") || string.equals("SM-T301i") || string.equals("SM-T300") || string.equals("SM-T301")) {
            this.removeProperty(31);
            this.m_config.addProperty("fullCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("partialCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("nearEndSensor", (Object)Boolean.FALSE);
            this.m_config.addProperty("fontB", (Object)Boolean.TRUE);
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class && 72.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                    this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
                }
            } else {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
            }
        } else if (string.equals("SM-T400i") || string.equals("SM-T401i")) {
            this.removeProperty(31);
            this.m_config.addProperty("fullCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("partialCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("nearEndSensor", (Object)Boolean.FALSE);
            this.m_config.addProperty("fontB", (Object)Boolean.TRUE);
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class && 104.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                    this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("832"));
                }
            } else {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("832"));
            }
        } else if (string.equals("SM-S210i") || string.equals("SM-S214i")) {
            this.removeProperty(31);
            this.m_config.addProperty("fullCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("partialCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("nearEndSensor", (Object)Boolean.FALSE);
            this.m_config.addProperty("fontB", (Object)Boolean.TRUE);
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class && 48.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                    this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("384"));
                }
            } else {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("384"));
            }
        } else if (string.equals("SM-S220i")) {
            this.removeProperty(31);
            this.m_config.addProperty("fullCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("partialCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("nearEndSensor", (Object)Boolean.FALSE);
            this.m_config.addProperty("fontB", (Object)Boolean.TRUE);
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class && 48.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                    this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("384"));
                }
            } else {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("384"));
            }
        } else if (string.equals("SM-S230i") || string.equals("SM-S234i")) {
            this.removeProperty(31);
            this.m_config.addProperty("fullCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("partialCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("nearEndSensor", (Object)Boolean.FALSE);
            this.m_config.addProperty("fontB", (Object)Boolean.TRUE);
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class && 48.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                    this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("384"));
                }
            } else {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("384"));
            }
        } else if (string.equals("SM-L200") || string.equals("SM-L204")) {
            this.removeProperty(31);
            this.m_config.addProperty("fullCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("partialCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("nearEndSensor", (Object)Boolean.FALSE);
            this.m_config.addProperty("fontB", (Object)Boolean.TRUE);
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class && 48.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                    this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("384"));
                }
            } else {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("384"));
            }
        } else if (string.equals("SM-L300") || string.equals("SM-L304")) {
            this.removeProperty(31);
            this.m_config.addProperty("fullCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("partialCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("nearEndSensor", (Object)Boolean.FALSE);
            this.m_config.addProperty("fontB", (Object)Boolean.TRUE);
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class) {
                    if (72.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
                    } else if (50.8 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("406"));
                    }
                }
            } else {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
            }
        } else if (string.equals("POP10")) {
            this.removeProperty(31);
            this.m_config.addProperty("fullCut", (Object)Boolean.TRUE);
            this.m_config.addProperty("partialCut", (Object)Boolean.TRUE);
            this.m_config.addProperty("nearEndSensor", (Object)Boolean.FALSE);
            this.m_config.addProperty("fontB", (Object)Boolean.TRUE);
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class) {
                    if (48.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("384"));
                    } else if (50.8 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("406"));
                    } else if (54.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("432"));
                    }
                }
            } else {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("384"));
            }
        } else if (string.equals("MCP30") || string.equals("MCP31")) {
            this.removeProperty(31);
            this.m_config.addProperty("fullCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("partialCut", (Object)Boolean.TRUE);
            this.m_config.addProperty("nearEndSensor", (Object)Boolean.TRUE);
            this.m_config.addProperty("fontB", (Object)Boolean.TRUE);
            if (string.equals("MCP30")) {
                this.removeProperty(4);
                this.m_config.addProperty("nearEndSensor", (Object)Boolean.FALSE);
            }
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class) {
                    if (72.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
                    } else if (48.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("384"));
                    } else if (50.8 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("406"));
                    } else if (52.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("416"));
                    }
                }
            } else {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
            }
        } else if (string.equals("MCP20") || string.equals("MCP21")) {
            this.removeProperty(31);
            this.m_config.addProperty("fullCut", (Object)Boolean.TRUE);
            this.m_config.addProperty("partialCut", (Object)Boolean.TRUE);
            this.m_config.addProperty("nearEndSensor", (Object)Boolean.FALSE);
            this.m_config.addProperty("fontB", (Object)Boolean.TRUE);
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class) {
                    if (48.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("384"));
                    } else if (50.8 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("406"));
                    } else if (54.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("432"));
                    }
                }
            } else {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("384"));
            }
        } else {
            return false;
        }
        if (this.m_config.hasPropertyWithName("printerCategory")) {
            this.m_config.removeProperty("printerCategory");
        }
        this.m_config.addProperty("printerCategory", (Object)String.valueOf("ThermalPrinter"));
        return true;
    }

    private boolean validateDotPrinterModel(String string) {
        if (string.equals("SP500") || string.equals("SP512") || string.equals("SP542")) {
            this.removeProperty(225);
            this.m_config.addProperty("fullCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("cap2Color", (Object)Boolean.FALSE);
            this.m_config.addProperty("cap18Pin", (Object)Boolean.FALSE);
            this.m_config.addProperty("coverOpen", (Object)Boolean.FALSE);
            if (this.m_config.hasPropertyWithName("nearEndSensor")) {
                if (this.m_config.getPropertyType("nearEndSensor") != Boolean.class) {
                    // empty if block
                }
            } else {
                this.m_config.addProperty("nearEndSensor", (Object)Boolean.FALSE);
            }
            if (string.equals("SP512")) {
                this.removeProperty(2);
                this.m_config.addProperty("partialCut", (Object)Boolean.FALSE);
            } else if (string.equals("SP542")) {
                this.removeProperty(2);
                this.m_config.addProperty("partialCut", (Object)Boolean.TRUE);
            } else if (this.m_config.hasPropertyWithName("partialCut")) {
                if (this.m_config.getPropertyType("partialCut") != Boolean.class) {
                    // empty if block
                }
            } else {
                this.m_config.addProperty("partialCut", (Object)Boolean.TRUE);
            }
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class) {
                    if (63.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("210"));
                    } else if (60.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("200"));
                    } else if (48.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("160"));
                    } else if (45.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("150"));
                    }
                }
            } else {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("210"));
            }
        } else if (string.equals("SP700") || string.equals("SP712") || string.equals("SP742") || string.equals("SP717") || string.equals("SP747")) {
            this.removeProperty(161);
            this.m_config.addProperty("fullCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("cap2Color", (Object)Boolean.TRUE);
            this.m_config.addProperty("coverOpen", (Object)Boolean.TRUE);
            if (this.m_config.hasPropertyWithName("nearEndSensor")) {
                if (this.m_config.getPropertyType("nearEndSensor") != Boolean.class) {
                    // empty if block
                }
            } else {
                this.m_config.addProperty("nearEndSensor", (Object)Boolean.FALSE);
            }
            if (string.equals("SP712") || string.equals("SP717")) {
                this.removeProperty(2);
                this.m_config.addProperty("partialCut", (Object)Boolean.FALSE);
            } else if (string.equals("SP742") || string.equals("SP747")) {
                this.removeProperty(2);
                this.m_config.addProperty("partialCut", (Object)Boolean.TRUE);
            } else if (this.m_config.hasPropertyWithName("partialCut")) {
                if (this.m_config.getPropertyType("partialCut") != Boolean.class) {
                    // empty if block
                }
            } else {
                this.m_config.addProperty("partialCut", (Object)Boolean.TRUE);
            }
            if (string.equals("SP712") || string.equals("SP742")) {
                this.removeProperty(64);
                this.m_config.addProperty("cap18Pin", (Object)Boolean.FALSE);
            } else if (string.equals("SP717") || string.equals("SP747")) {
                this.removeProperty(64);
                this.m_config.addProperty("cap18Pin", (Object)Boolean.TRUE);
            } else if (this.m_config.hasPropertyWithName("cap18Pin")) {
                if (this.m_config.getPropertyType("cap18Pin") != Boolean.class) {
                    // empty if block
                }
            } else {
                this.m_config.addProperty("cap18Pin", (Object)Boolean.FALSE);
            }
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class) {
                    if (63.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("210"));
                    } else if (60.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("200"));
                    } else if (48.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("160"));
                    } else if (45.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("150"));
                    }
                }
            } else {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("210"));
            }
        } else {
            return false;
        }
        if (this.m_config.hasPropertyWithName("printerCategory")) {
            this.m_config.removeProperty("printerCategory");
        }
        this.m_config.addProperty("printerCategory", (Object)String.valueOf("DotPrinter"));
        return true;
    }

    private boolean validateHybridPrinterModel(String string) {
        if (string.equals("HSP7000")) {
            this.removeProperty(95);
            this.m_config.addProperty("fullCut", (Object)Boolean.FALSE);
            this.m_config.addProperty("partialCut", (Object)Boolean.TRUE);
            this.m_config.addProperty("nearEndSensor", (Object)Boolean.TRUE);
            this.m_config.addProperty("fontB", (Object)Boolean.TRUE);
            this.m_config.addProperty("cap18Pin", (Object)Boolean.FALSE);
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class) {
                    if (72.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
                    } else if (51.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("408"));
                    }
                }
            } else {
                this.m_config.addProperty("dotLineWidth", (Object)Integer.valueOf("576"));
            }
        } else {
            return false;
        }
        if (this.m_config.hasPropertyWithName("printerCategory")) {
            this.m_config.removeProperty("printerCategory");
        }
        this.m_config.addProperty("printerCategory", (Object)String.valueOf("HybridPrinter"));
        return true;
    }

    private void removeProperty(int n) {
        if (1 == (n & 1)) {
            if (this.m_config.hasPropertyWithName("fullCut")) {
                this.m_config.removeProperty("fullCut");
            }
        } else if (2 == (n & 2)) {
            if (this.m_config.hasPropertyWithName("partialCut")) {
                this.m_config.removeProperty("partialCut");
            }
        } else if (4 == (n & 4)) {
            if (this.m_config.hasPropertyWithName("nearEndSensor")) {
                this.m_config.removeProperty("nearEndSensor");
            }
        } else if (8 == (n & 8)) {
            if (this.m_config.hasPropertyWithName("fontB")) {
                this.m_config.removeProperty("fontB");
            }
        } else if (16 == (n & 0x10)) {
            if (this.m_config.hasPropertyWithName("dotLineWidth")) {
                this.m_config.removeProperty("dotLineWidth");
            }
        } else if (32 == (n & 0x20)) {
            if (this.m_config.hasPropertyWithName("cap2Color")) {
                this.m_config.removeProperty("cap2Color");
            }
        } else if (64 == (n & 0x40)) {
            if (this.m_config.hasPropertyWithName("cap18Pin")) {
                this.m_config.removeProperty("cap18Pin");
            }
        } else if (128 == (n & 0x80) && this.m_config.hasPropertyWithName("coverOpen")) {
            this.m_config.removeProperty("coverOpen");
        }
    }
}

