/*
 * Decompiled with CFR 0.152.
 */
package com.starmicronics.stario;

import com.starmicronics.stario.StarIOPortException;
import com.starmicronics.stario.StarPrinterStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Vector;

public class StarIOPort {
    private final String m_portName;
    private final String m_portSettings;
    private long m_nativePort;
    private int m_usageCount;
    private static boolean s_classServicesReadied = false;
    private static final Vector s_ports;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized StarIOPort getPort(String string, String string2, int n) throws StarIOPortException {
        if (!s_classServicesReadied) {
            throw new StarIOPortException("The required native libraries  & class services are not available.");
        }
        for (int i = 0; i < s_ports.size(); ++i) {
            StarIOPort starIOPort = (StarIOPort)s_ports.get(i);
            if (!starIOPort.m_portName.equals(string)) continue;
            if (starIOPort.m_portSettings.equals(string2)) {
                StarIOPort starIOPort2 = starIOPort;
                synchronized (starIOPort2) {
                    ++starIOPort.m_usageCount;
                    return starIOPort;
                }
            }
            throw new StarIOPortException("This port is already opened and is configured with different settings.");
        }
        StarIOPort starIOPort = new StarIOPort(string, string2, n);
        s_ports.add(starIOPort);
        return starIOPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void releasePort(StarIOPort starIOPort) {
        for (int i = 0; i < s_ports.size(); ++i) {
            StarIOPort starIOPort2 = (StarIOPort)s_ports.get(i);
            if (starIOPort2 != starIOPort) continue;
            StarIOPort starIOPort3 = starIOPort2;
            synchronized (starIOPort3) {
                if (--starIOPort2.m_usageCount == 0) {
                    starIOPort2.closeNative();
                    s_ports.remove(starIOPort2);
                }
                break;
            }
        }
    }

    public synchronized String getPortName() {
        return this.m_portName;
    }

    public synchronized String getPortSettings() {
        return this.m_portSettings;
    }

    public synchronized int writePort(byte[] byArray, int n, int n2) throws StarIOPortException {
        if (this.m_nativePort == 0L) {
            throw new StarIOPortException("This port has been closed.");
        }
        int[] nArray = new int[1];
        if (StarIOPort.nativeWritePort(this.m_nativePort, byArray, n, n2, nArray) == 0) {
            throw new StarIOPortException("The native writePort function failed.");
        }
        return nArray[0];
    }

    public synchronized int readPort(byte[] byArray, int n, int n2) throws StarIOPortException {
        if (this.m_nativePort == 0L) {
            throw new StarIOPortException("This port has been closed.");
        }
        int[] nArray = new int[1];
        if (StarIOPort.nativeReadPort(this.m_nativePort, byArray, n, n2, nArray) == 0) {
            throw new StarIOPortException("The native readPort function failed.");
        }
        return nArray[0];
    }

    public synchronized StarPrinterStatus retreiveStatus() throws StarIOPortException {
        if (this.m_nativePort == 0L) {
            throw new StarIOPortException("This port has been closed.");
        }
        StarPrinterStatus starPrinterStatus = new StarPrinterStatus();
        if (StarIOPort.nativeGetParsedStatus(this.m_nativePort, starPrinterStatus) == 0) {
            throw new StarIOPortException("The native retreiveStatus function failed.");
        }
        return starPrinterStatus;
    }

    public synchronized StarPrinterStatus beginCheckedBlock() throws StarIOPortException {
        if (this.m_nativePort == 0L) {
            throw new StarIOPortException("This port has been closed.");
        }
        StarPrinterStatus starPrinterStatus = new StarPrinterStatus();
        if (StarIOPort.nativeBeginCheckedBlock(this.m_nativePort, starPrinterStatus) == 0) {
            throw new StarIOPortException("The native beginCheckedBlock function failed.");
        }
        return starPrinterStatus;
    }

    public synchronized StarPrinterStatus endCheckedBlock() throws StarIOPortException {
        if (this.m_nativePort == 0L) {
            throw new StarIOPortException("This port has been closed.");
        }
        StarPrinterStatus starPrinterStatus = new StarPrinterStatus();
        if (StarIOPort.nativeEndCheckedBlock(this.m_nativePort, starPrinterStatus) == 0) {
            throw new StarIOPortException("The native endCheckedBlock function failed.");
        }
        return starPrinterStatus;
    }

    public synchronized void resetDevice() throws StarIOPortException {
        if (this.m_nativePort == 0L) {
            throw new StarIOPortException("This port has been closed.");
        }
        if (StarIOPort.nativeResetDevice(this.m_nativePort) == 0) {
            throw new StarIOPortException("The native resetDevice function failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void cleanupAllOpenPorts() {
        for (int i = 0; i < s_ports.size(); ++i) {
            StarIOPort starIOPort;
            StarIOPort starIOPort2 = starIOPort = (StarIOPort)s_ports.get(i);
            synchronized (starIOPort2) {
                starIOPort.closeNative();
                continue;
            }
        }
    }

    private StarIOPort(String string, String string2, int n) throws StarIOPortException {
        this.m_portName = string;
        this.m_portSettings = string2;
        this.m_nativePort = StarIOPort.nativeOpenPort(this.m_portName, this.m_portSettings, n);
        if (this.m_nativePort == 0L) {
            throw new StarIOPortException(false, "The native OpenPort function failed.");
        }
        this.m_usageCount = 1;
    }

    protected void finalize() throws Throwable {
        this.closeNative();
        super.finalize();
    }

    private void closeNative() {
        if (this.m_nativePort != 0L) {
            StarIOPort.nativeClosePort(this.m_nativePort);
            this.m_nativePort = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean isInstalledLibraryBinarySame(String string) {
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        try {
            inputStream = new FileInputStream(new File(System.getProperty("java.io.tmpdir") + "/" + string));
            byte[] byArray = new byte[10240];
            inputStream2 = StarIOPort.class.getClassLoader().getResource("com/starmicronics/stario/natives/" + string).openStream();
            byte[] byArray2 = new byte[10240];
            block32: while (true) {
                int n;
                int n2;
                if ((n2 = inputStream.read(byArray)) <= 0) {
                    if (inputStream2.read(byArray2) > 0) {
                        n = 0;
                        return n != 0;
                    }
                    n = 1;
                    return n != 0;
                }
                n = 0;
                while (true) {
                    int n3;
                    if (n2 <= 0) continue block32;
                    int n4 = inputStream2.read(byArray2, 0, n2);
                    if (n4 <= 0) {
                        n3 = 0;
                        return n3 != 0;
                    }
                    n2 -= n4;
                    for (n3 = 0; n3 < n4; ++n3) {
                        if (byArray[n + n3] == byArray2[n3]) continue;
                        boolean bl = false;
                        return bl;
                    }
                    n += n4;
                }
                break;
            }
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (inputStream2 != null) {
                    inputStream2.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String installNativeLibrary(String string) throws Exception {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = StarIOPort.class.getClassLoader().getResource("com/starmicronics/stario/natives/" + string).openStream();
            String string2 = System.getProperty("java.io.tmpdir") + "/" + string;
            File file = new File(string2);
            file.delete();
            outputStream = new FileOutputStream(file);
            byte[] byArray = new byte[10240];
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
            String string3 = string2;
            return string3;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private static final String mapLibraryName(String string) {
        if (System.getProperty("os.name").equals("Mac OS X")) {
            return "lib" + string + ".dylib";
        }
        return System.mapLibraryName(string);
    }

    private static final native long nativeOpenPort(String var0, String var1, int var2);

    private static final native int nativeClosePort(long var0);

    private static final native int nativeReadPort(long var0, byte[] var2, int var3, int var4, int[] var5);

    private static final native int nativeWritePort(long var0, byte[] var2, int var3, int var4, int[] var5);

    private static final native int nativeGetParsedStatus(long var0, StarPrinterStatus var2);

    private static final native int nativeBeginCheckedBlock(long var0, StarPrinterStatus var2);

    private static final native int nativeEndCheckedBlock(long var0, StarPrinterStatus var2);

    private static final native int nativeResetDevice(long var0);

    static {
        int n = 0;
        String[] stringArray = new String[]{"StarIOPort", "StarIOJ"};
        if (System.getProperty("os.name").equals("Linux") || System.getProperty("os.name").equals("Mac OS X")) {
            stringArray = new String[]{"StarIOPort", "StarIOJ", "starusb"};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = StarIOPort.mapLibraryName(stringArray[i]);
            try {
                Runtime.getRuntime().load(System.getProperty("smj.dllpath") + "/" + string);
                ++n;
                continue;
            }
            catch (Throwable throwable) {
                try {
                    File file = null;
                    String string2 = StarIOPort.class.getName().replace('.', '/') + ".class";
                    URL uRL = StarIOPort.class.getClassLoader().getResource(string2);
                    String string3 = uRL.getFile();
                    if (uRL.getProtocol().equals("jar")) {
                        int n2 = string3.lastIndexOf("!");
                        if (n2 == -1) {
                            throw new Error("Couldn't get path of jar file");
                        }
                        string3 = string3.substring(0, n2);
                        URI uRI = new URI(string3);
                        file = new File(uRI);
                    }
                    file = file == null ? new File(".") : file.getParentFile();
                    Runtime.getRuntime().load(file.getAbsolutePath() + "/" + string);
                    ++n;
                    continue;
                }
                catch (Throwable throwable2) {
                    try {
                        System.loadLibrary(stringArray[i]);
                        ++n;
                        continue;
                    }
                    catch (Throwable throwable3) {
                        try {
                            if (!StarIOPort.isInstalledLibraryBinarySame(string)) {
                                StarIOPort.installNativeLibrary(string);
                            }
                            Runtime.getRuntime().load(System.getProperty("java.io.tmpdir") + "/" + string);
                            ++n;
                            continue;
                        }
                        catch (Throwable throwable4) {
                            break;
                        }
                    }
                }
            }
        }
        if (n == stringArray.length) {
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        StarIOPort.cleanupAllOpenPorts();
                    }
                });
                s_classServicesReadied = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        s_ports = new Vector();
    }
}

